/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.manager;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.utils.Msg;
import de.scholle.minecrafthelden.utils.TextureGlyphs;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class CombatManager {
    private final MinecraftHelden plugin;
    private final Map<UUID, Long> combatUntil;
    private final Map<UUID, UUID> lastAttacker;
    private final Map<UUID, Long> lastAttackMsg;
    private final Set<UUID> wasInCombat;
    private final Set<UUID> inCombatLogged;
    private final Map<UUID, Integer> pearlsUsed;
    private final Map<UUID, BossBar> bars;
    private boolean pvpEnabled;
    private BukkitTask barTask;
    private static final int MAX_PEARLS = 16;
    private static final long COMBAT_DURATION_MS = 30000L;

    public CombatManager(MinecraftHelden plugin) {
        this.plugin = plugin;
        this.combatUntil = new HashMap<UUID, Long>();
        this.lastAttacker = new HashMap<UUID, UUID>();
        this.lastAttackMsg = new HashMap<UUID, Long>();
        this.wasInCombat = new HashSet<UUID>();
        this.inCombatLogged = new HashSet<UUID>();
        this.pearlsUsed = new HashMap<UUID, Integer>();
        this.bars = new HashMap<UUID, BossBar>();
        this.pvpEnabled = true;
    }

    public void start() {
        this.stop();
        this.barTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            long now = System.currentTimeMillis();
            boolean bossEnabled = this.plugin.getConfig().getBoolean("combat.bossbar.enabled");
            for (Player p : Bukkit.getOnlinePlayers()) {
                UUID id = p.getUniqueId();
                Long until = this.combatUntil.get(id);
                int lives = this.plugin.getLivesStore().getLives(id);
                String hearts = TextureGlyphs.heartsBar(lives);
                if (until != null && until > now) {
                    this.wasInCombat.add(id);
                    long secs = (until - now) / 1000L;
                    if (bossEnabled) {
                        this.updateBossbar(p, secs);
                        p.sendActionBar(Msg.comp(hearts));
                        continue;
                    }
                    p.sendActionBar(Msg.comp("&cIm Kampf! &7(" + secs + "s \u00fcbrig)"));
                    continue;
                }
                if (!this.wasInCombat.remove(id)) continue;
                this.clearCombat(id, true);
                if (bossEnabled) {
                    this.removeBossbar(p);
                    p.sendActionBar(Msg.comp(hearts));
                    continue;
                }
                p.sendActionBar((Component)Component.empty());
            }
        }, 20L, 20L);
    }

    private void updateBossbar(Player p, long secs) {
        double progress;
        BossBar bar = this.bars.get(p.getUniqueId());
        if (bar == null) {
            bar = Bukkit.createBossBar((String)"Im Kampf", (BarColor)BarColor.RED, (BarStyle)BarStyle.SEGMENTED_10, (BarFlag[])new BarFlag[0]);
            bar.addPlayer(p);
            this.bars.put(p.getUniqueId(), bar);
        }
        if ((progress = (double)secs / 30.0) < 0.0) {
            progress = 0.0;
        }
        if (progress > 1.0) {
            progress = 1.0;
        }
        bar.setProgress(progress);
        bar.setTitle("Im Kampf: " + secs + "s");
    }

    private void removeBossbar(Player p) {
        BossBar bar = this.bars.remove(p.getUniqueId());
        if (bar != null) {
            bar.removeAll();
        }
    }

    public void stop() {
        if (this.barTask != null) {
            this.barTask.cancel();
        }
        for (BossBar bar : this.bars.values()) {
            bar.removeAll();
        }
        this.bars.clear();
    }

    public void shutdown() {
        this.stop();
        this.combatUntil.clear();
        this.lastAttacker.clear();
        this.lastAttackMsg.clear();
        this.wasInCombat.clear();
        this.inCombatLogged.clear();
        this.pearlsUsed.clear();
    }

    public void endCombat(UUID id, boolean notify) {
        this.clearCombat(id, notify);
    }

    public void setPvPEnabled(boolean enabled, CommandSender actor) {
        if (this.pvpEnabled == enabled) {
            if (actor != null) {
                actor.sendMessage((Component)Component.text((String)(enabled ? "\u00a7ePvP ist bereits \u00a7aaktiv\u00a7e." : "\u00a7ePvP ist bereits \u00a7cdeaktiviert\u00a7e.")));
            }
            return;
        }
        this.pvpEnabled = enabled;
        String actorName = actor != null ? actor.getName() : "Konsole";
        String msg = enabled ? "&eDas PvP wurde von &a" + actorName + " &ewieder aktiviert!" : "&eDas PvP wurde von &c" + actorName + " &edeaktiviert!";
        Bukkit.getServer().broadcast(Msg.comp("&f[&6&l\u1d04\u1d07\u029f\u1d05\u1d07\u0274&f] " + msg));
        Sound s = enabled ? Sound.sound((Key)Key.key((String)"minecraft:block.note_block.pling"), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.6f) : Sound.sound((Key)Key.key((String)"minecraft:block.anvil.land"), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)0.6f);
        for (Player online : Bukkit.getOnlinePlayers()) {
            online.playSound(s);
        }
    }

    public boolean isPvPEnabled() {
        return this.pvpEnabled;
    }

    public boolean isInCombat(UUID id) {
        Long until = this.combatUntil.get(id);
        return until != null && until > System.currentTimeMillis();
    }

    public String remainingSeconds(UUID id) {
        long until = this.combatUntil.getOrDefault(id, 0L);
        long diff = until - System.currentTimeMillis();
        return diff <= 0L ? "0" : String.valueOf(diff / 1000L);
    }

    public UUID getLastAttacker(UUID id) {
        return this.lastAttacker.get(id);
    }

    public void clearCombat(UUID id, boolean notify) {
        Player pl;
        boolean was = this.isInCombat(id);
        this.combatUntil.remove(id);
        this.wasInCombat.remove(id);
        this.lastAttacker.remove(id);
        this.lastAttackMsg.remove(id);
        this.pearlsUsed.remove(id);
        Player p = Bukkit.getPlayer((UUID)id);
        if (p != null && notify && was) {
            p.sendMessage(Msg.comp("&f[&6&l\u1d04\u1d07\u029f\u1d05\u1d07\u0274&f] &aDu bist wieder sicher. Der Kampf ist vorbei!"));
        }
        if ((pl = Bukkit.getPlayer((UUID)id)) != null) {
            this.removeBossbar(pl);
        }
    }

    public void maybeNotifyOncePerMinute(UUID playerId, String msg) {
        long now = System.currentTimeMillis();
        Long last = this.lastAttackMsg.get(playerId);
        if (last == null || now - last >= 60000L) {
            this.lastAttackMsg.put(playerId, now);
            Player p = Bukkit.getPlayer((UUID)playerId);
            if (p != null) {
                p.sendMessage(Msg.comp("&f[&6&l\u1d04\u1d07\u029f\u1d05\u1d07\u0274&f] " + msg));
            }
        }
    }

    public boolean overPearlLimit(UUID id) {
        return this.isInCombat(id) && this.pearlsUsed.getOrDefault(id, 0) >= 16;
    }

    public int tryConsumePearl(UUID id) {
        if (!this.isInCombat(id)) {
            return -1;
        }
        int used = this.pearlsUsed.getOrDefault(id, 0);
        if (used >= 16) {
            return -1;
        }
        this.pearlsUsed.put(id, ++used);
        return 16 - used;
    }

    public void startOrRefreshCombat(Player attacker, Player victim) {
        long now = System.currentTimeMillis();
        long until = now + 30000L;
        this.combatUntil.put(attacker.getUniqueId(), until);
        this.combatUntil.put(victim.getUniqueId(), until);
        this.lastAttacker.put(victim.getUniqueId(), attacker.getUniqueId());
        this.wasInCombat.add(attacker.getUniqueId());
        this.wasInCombat.add(victim.getUniqueId());
    }
}

