/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.manager;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class SettingsManager {
    private final MinecraftHelden plugin;
    private final File settingsFile;
    private final FileConfiguration settingsConfig;

    public SettingsManager(MinecraftHelden plugin) {
        this.plugin = plugin;
        this.settingsFile = new File(plugin.getDataFolder(), "settings.yml");
        if (!this.settingsFile.exists()) {
            try {
                this.settingsFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.settingsConfig = YamlConfiguration.loadConfiguration((File)this.settingsFile);
    }

    public boolean isArmorLockEnabled(UUID playerId) {
        return this.settingsConfig.getBoolean("players." + String.valueOf(playerId) + ".armorlockgui", true);
    }

    public void setArmorLock(UUID playerId, boolean enabled) {
        this.settingsConfig.set("players." + String.valueOf(playerId) + ".armorlockgui", (Object)enabled);
        try {
            this.settingsConfig.save(this.settingsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

