/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.listeners;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.utils.Msg;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class KeepInventoryListener
implements Listener {
    private final MinecraftHelden plugin;

    public KeepInventoryListener(MinecraftHelden plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent e) {
        double keepPercentage;
        Player victim = e.getEntity();
        UUID id = victim.getUniqueId();
        boolean wasInCombat = this.plugin.combat().isInCombat(id);
        double d = keepPercentage = wasInCombat ? this.plugin.getConfig().getDouble("keepInventoryPercentageCombat", 0.0) : this.plugin.getConfig().getDouble("keepInventoryPercentageNatural", 0.0);
        if (keepPercentage <= 0.0) {
            return;
        }
        ArrayList<ItemStack> keptItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> droppedItems = new ArrayList<ItemStack>();
        for (ItemStack item : e.getDrops()) {
            if (item == null) continue;
            if (Math.random() < keepPercentage) {
                keptItems.add(item.clone());
                continue;
            }
            droppedItems.add(item);
        }
        e.getDrops().clear();
        e.getDrops().addAll(droppedItems);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Player p = Bukkit.getPlayer((UUID)id);
            if (p != null && p.isOnline()) {
                for (ItemStack item : keptItems) {
                    p.getInventory().addItem(new ItemStack[]{item});
                }
                Msg.send((CommandSender)p, "&aDu hast &f" + (int)(keepPercentage * 100.0) + "% &adeiner Items behalten.");
            }
        }, 20L);
    }
}

