/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.storage;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class DuelStore {
    private final Plugin plugin;
    private final File file;
    private FileConfiguration cfg;

    public DuelStore(Plugin plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "duels.yml");
        this.reload();
    }

    public void reload() {
        if (!this.file.exists()) {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.cfg = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public int getUsed(UUID id) {
        return this.cfg.getInt("used." + id.toString(), 0);
    }

    public void incUsed(UUID id) {
        int v = this.getUsed(id) + 1;
        this.cfg.set("used." + id.toString(), (Object)v);
        this.saveNow();
    }

    public void saveNow() {
        try {
            this.cfg.save(this.file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

