/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.webhooks;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DiscordLogger {
    private final String adminUrl;
    private final String killUrl;
    private final HttpClient http;
    private final ExecutorService pool = Executors.newFixedThreadPool(2);
    private final Set<String> recentKillKeys = ConcurrentHashMap.newKeySet();
    private static final long DEDUP_MS = 3000L;
    private static final ZoneId BERLIN = ZoneId.of("Europe/Berlin");
    private static final DateTimeFormatter DATE_FULL = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter TIME_PRETTY = DateTimeFormatter.ofPattern("HH:mm");

    public DiscordLogger(String adminUrl, String killUrl) {
        this.adminUrl = adminUrl;
        this.killUrl = killUrl;
        this.http = HttpClient.newBuilder().executor(this.pool).build();
    }

    public void shutdown() {
        this.pool.shutdownNow();
    }

    public void adminCommand(String actor, String command, String details) {
        if (this.adminUrl == null || this.adminUrl.isBlank()) {
            return;
        }
        JsonObject embed = this.baseEmbed(15844367, "ADMIN LOG \ud83d\udd27", null);
        this.addField(embed, "ADMIN", this.safe(actor), true);
        this.addField(embed, "COMMAND", "```" + this.safe(command) + "```", false);
        if (details != null && !details.isBlank()) {
            this.addField(embed, "DETAILS", this.safe(details), false);
        }
        this.post(this.adminUrl, embed);
    }

    public void pvPKill(String killer, String victim, int livesLeft) {
        this.pvPKill(killer, victim, livesLeft, false, null);
    }

    public void pvPKill(String killer, String victim, int livesLeft, boolean eliminated) {
        this.pvPKill(killer, victim, livesLeft, eliminated, null);
    }

    public void pvPKill(String killer, String victim, int livesLeft, boolean eliminated, String explicitDate) {
        String v;
        if (this.killUrl == null || this.killUrl.isBlank()) {
            return;
        }
        String k = this.safe(killer == null ? "unbekannt" : killer);
        String key = k + "|" + (v = this.safe(Objects.requireNonNullElse(victim, "???")));
        if (!this.recentKillKeys.add(key)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.recentKillKeys.remove(key);
        });
        LocalDateTime nowBerlin = LocalDateTime.now(BERLIN);
        String dateLine = explicitDate != null ? explicitDate : DATE_FULL.format(nowBerlin);
        String pretty = "heute um " + TIME_PRETTY.format(nowBerlin) + " Uhr";
        JsonObject e = this.baseEmbed(15548997, "KILL LOG \ud83d\udde1\ufe0f", null);
        this.addField(e, k + " **hat** " + v + " **get\u00f6tet**", "\ud83d\udc94 **Leben \u00fcbrig:** " + String.valueOf(eliminated ? "0 (AUSGESCHIEDEN)" : Integer.valueOf(livesLeft)), false);
        this.addField(e, "DATUM", dateLine, true);
        this.addField(e, "", pretty, true);
        this.post(this.killUrl, e);
    }

    public void combatEnter(String player, int seconds) {
    }

    public void combatExit(String player, String reason) {
    }

    public void combatLogDeath(String killer, String victim, int livesLeft) {
        this.pvPKill(killer, victim, livesLeft, false, null);
    }

    public void combatLogDeath(String killer, String victim, int livesLeft, String date) {
        this.pvPKill(killer, victim, livesLeft, false, date);
    }

    public void dummyKill(String killer, String victimOwner, int livesLeft) {
        this.pvPKill(killer, victimOwner, livesLeft, false, null);
    }

    public void dummyKill(String killer, String victimOwner, int livesLeft, String date) {
        this.pvPKill(killer, victimOwner, livesLeft, false, date);
    }

    private JsonObject baseEmbed(int color, String title, String desc) {
        JsonObject embed = new JsonObject();
        embed.addProperty("title", title);
        if (desc != null) {
            embed.addProperty("description", desc);
        }
        embed.addProperty("color", (Number)color);
        embed.addProperty("timestamp", OffsetDateTime.now(ZoneOffset.UTC).toString());
        return embed;
    }

    private void addField(JsonObject embed, String name, String value, boolean inline) {
        JsonArray fields = embed.has("fields") ? embed.getAsJsonArray("fields") : new JsonArray();
        JsonObject f = new JsonObject();
        f.addProperty("name", name == null ? "" : name);
        f.addProperty("value", value == null ? "" : value);
        f.addProperty("inline", Boolean.valueOf(inline));
        fields.add((JsonElement)f);
        embed.add("fields", (JsonElement)fields);
    }

    private void post(String url, JsonObject embed) {
        try {
            JsonObject payload = new JsonObject();
            JsonArray embeds = new JsonArray();
            embeds.add((JsonElement)embed);
            payload.add("embeds", (JsonElement)embeds);
            HttpRequest req = HttpRequest.newBuilder(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(payload.toString(), StandardCharsets.UTF_8)).build();
            this.http.sendAsync(req, HttpResponse.BodyHandlers.discarding());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String safe(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("@everyone", "@ everyone").replace("@here", "@ here");
    }
}

