/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.manager;

import de.scholle.minecrafthelden.MinecraftHelden;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class SettingsManager {
    private final MinecraftHelden plugin;
    private final File settingsFile;
    private final FileConfiguration settingsConfig;

    public SettingsManager(MinecraftHelden plugin) {
        this.plugin = plugin;
        this.settingsFile = new File(plugin.getDataFolder(), "settings.yml");
        if (!this.settingsFile.exists()) {
            try {
                this.settingsFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.settingsConfig = YamlConfiguration.loadConfiguration((File)this.settingsFile);
    }

    public boolean isArmorLockEnabled(UUID playerId) {
        return this.settingsConfig.getBoolean("players." + String.valueOf(playerId) + ".armorlockgui", true);
    }

    public void setArmorLock(UUID playerId, boolean enabled) {
        this.settingsConfig.set("players." + String.valueOf(playerId) + ".armorlockgui", (Object)enabled);
        try {
            this.settingsConfig.save(this.settingsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

