/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class Boot {
    private static final String STORED_SALT_B64 = "LopO06aBwsXc1T3BP676KA==";
    private static final String STORED_HASH_B64 = "n29PiZhGJM5D0hBpR5jjKyKQHhUmEBLaHJMEWca8Thw=";
    private static final int PBKDF2_ITERATIONS = 200000;
    private static final int DERIVED_KEY_LEN = 256;
    private static boolean premiumActive = false;

    public static void verify(Plugin plugin) {
        boolean validKey;
        FileConfiguration config = plugin.getConfig();
        String providedKey = config.getString("master-key", "");
        try {
            validKey = Boot.verifyMasterKey(providedKey);
        }
        catch (Exception e) {
            plugin.getLogger().severe("Fehler bei Master-Key-Validierung: " + e.getMessage());
            Bukkit.getPluginManager().disablePlugin(plugin);
            return;
        }
        premiumActive = validKey;
        if (!validKey) {
            int duelLimit = config.getInt("duels.limit", 0);
            if (duelLimit != 0) {
                plugin.getLogger().severe("\u274c duels.limit darf ohne g\u00fcltigen Master-Key nicht ver\u00e4ndert werden!");
                Bukkit.getPluginManager().disablePlugin(plugin);
                return;
            }
            if (config.getBoolean("armorlock.enabled", false)) {
                plugin.getLogger().severe("\u274c armorlock.enabled darf ohne g\u00fcltigen Master-Key nicht aktiviert sein!");
                Bukkit.getPluginManager().disablePlugin(plugin);
                return;
            }
            if (config.getBoolean("texturepack.changedefaultpack", false)) {
                plugin.getLogger().severe("\u274c texturepack.changedefaultpack darf ohne g\u00fcltigen Master-Key nicht aktiviert sein!");
                Bukkit.getPluginManager().disablePlugin(plugin);
                return;
            }
            if (config.getBoolean("glowing", false)) {
                plugin.getLogger().severe("\u274c glowing darf ohne g\u00fcltigen Master-Key nicht aktiviert sein!");
                Bukkit.getPluginManager().disablePlugin(plugin);
                return;
            }
            if (config.getBoolean("webhooks.enabled", false)) {
                plugin.getLogger().severe("\u274c Webhooks d\u00fcrfen ohne g\u00fcltigen Master-Key nicht aktiviert werden!");
                Bukkit.getPluginManager().disablePlugin(plugin);
                return;
            }
            String linkedHeartGen = config.getString("linkedheart.enabled", "false");
            if ("true".equalsIgnoreCase(linkedHeartGen)) {
                plugin.getLogger().severe("\u274c linkedheart darf ohne g\u00fcltigen Master-Key nicht an sein!");
                Bukkit.getPluginManager().disablePlugin(plugin);
                return;
            }
            String combatLog = config.getString("combat-log", "kill-on-logout");
            if ("dummy".equalsIgnoreCase(combatLog)) {
                plugin.getLogger().severe("\u274c combat-log darf ohne g\u00fcltigen Master-Key nicht auf 'dummy' stehen!");
                Bukkit.getPluginManager().disablePlugin(plugin);
                return;
            }
            if (!Boot.checkCommands(config)) {
                plugin.getLogger().severe("\u274c Einige commands d\u00fcrfen ohne g\u00fcltigen Master-Key nicht auf true/anders gesetzt sein!");
                Bukkit.getPluginManager().disablePlugin(plugin);
                return;
            }
            plugin.getLogger().info("\u2705 Kein Master-Key oder ung\u00fcltiger Key. Nur Standard-Features aktiv.");
            return;
        }
        plugin.getLogger().info("\u2705 Master-Key validiert. Premium-Features freigeschaltet.");
    }

    public static boolean isPremium() {
        return premiumActive;
    }

    private static boolean checkCommands(FileConfiguration config) {
        String[] requiredCommands;
        for (String cmd : requiredCommands = new String[]{"discord", "dc", "mobilestars", "fernsehheft", "youtube", "yt", "instagram", "insta", "tiktok", "paypal", "license", "version"}) {
            if (config.getBoolean("commands." + cmd, true)) continue;
            return false;
        }
        return true;
    }

    private static boolean verifyMasterKey(String providedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (providedKey == null || providedKey.isEmpty()) {
            return false;
        }
        byte[] salt = Base64.getDecoder().decode(STORED_SALT_B64);
        byte[] expectedHash = Base64.getDecoder().decode(STORED_HASH_B64);
        byte[] derived = Boot.pbkdf2(providedKey.toCharArray(), salt, 200000, 256);
        return Boot.constantTimeEquals(expectedHash, derived);
    }

    private static byte[] pbkdf2(char[] password, byte[] salt, int iterations, int keyLengthBits) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, keyLengthBits);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        return skf.generateSecret(spec).getEncoded();
    }

    private static boolean constantTimeEquals(byte[] a, byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < a.length; ++i) {
            result |= a[i] ^ b[i];
        }
        return result == 0;
    }
}

