/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.listeners;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import de.scholle.minecrafthelden.utils.BanUtil;
import de.scholle.minecrafthelden.utils.Msg;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class QuitListener
implements Listener {
    private final MinecraftHelden plugin;
    private static final DateTimeFormatter TS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public QuitListener(MinecraftHelden plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        block24: {
            Player p = e.getPlayer();
            UUID id = p.getUniqueId();
            try {
                if (this.plugin.spectatorBypass().isBypassing(id)) {
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.plugin.lives().getLives(id) <= 0) {
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (BanUtil.isBanned(p.getName())) {
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                block25: {
                    if (this.plugin.combat() == null || !this.plugin.combat().isInCombat(id)) break block24;
                    String killerNameForMsg = "unbekannt";
                    try {
                        Player lastP;
                        UUID last = this.plugin.combat().getLastAttacker(id);
                        if (last != null && (lastP = Bukkit.getPlayer((UUID)last)) != null) {
                            killerNameForMsg = lastP.getName();
                        }
                    }
                    catch (Throwable last) {
                        // empty catch block
                    }
                    int before = this.plugin.lives().getLives(id);
                    int after = Math.max(0, before - 1);
                    this.plugin.lives().setLives(id, after);
                    Bukkit.getServer().broadcast(Msg.comp("&f[&6&l\u029c\u1d07\u029f\u1d05\u1d07\u0274&f] &c" + p.getName() + " &fwurde von &a" + killerNameForMsg + " &fbesiegt. &7(Leben: &f" + after + "&7)"));
                    try {
                        if (this.plugin.discord() != null) {
                            String date = LocalDateTime.now().format(TS);
                            this.plugin.discord().pvPKill(killerNameForMsg, p.getName(), after, after == 0, date);
                        }
                    }
                    catch (Throwable date) {
                        // empty catch block
                    }
                    try {
                        this.plugin.combat().endCombat(id, false);
                    }
                    catch (Throwable date) {
                        // empty catch block
                    }
                    if (after == 0) {
                        try {
                            boolean hasRevive;
                            UUID partnerId = this.plugin.linkedHearts().getPartner(id);
                            boolean bl = hasRevive = partnerId != null && this.plugin.linkedHearts().hasReviveLeft(id);
                            if (hasRevive) {
                                this.plugin.dummies().markPendingRevive(id);
                                break block25;
                            }
                            this.plugin.dummies().markPendingDeath(id);
                        }
                        catch (Throwable throwable) {}
                    } else {
                        this.plugin.dummies().markPendingDeathWithDrops(id);
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.plugin.dummies().spawnOnLogout(e.getPlayer());
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

