/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.commands;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import de.scholle.minecrafthelden.utils.TabCompleteUtil;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;

public class CombatCommand
implements CommandExecutor,
TabCompleter {
    private final MinecraftHelden plugin;

    public CombatCommand(MinecraftHelden plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String sub;
        if (!sender.hasPermission("helden.combat")) {
            sender.sendMessage("\u00a7cDazu hast du keine Rechte.");
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage("\u00a7cUsage: /combat <pvpon|pvpoff>");
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "pvpon": {
                this.plugin.combat().setPvPEnabled(true, sender);
                return true;
            }
            case "pvpoff": {
                this.plugin.combat().setPvPEnabled(false, sender);
                return true;
            }
        }
        sender.sendMessage("\u00a7cUsage: /combat <pvpon|pvpoff>");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        return TabCompleteUtil.completeCombat(args);
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

