/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class SkinFetcher {
    private static final HttpClient HTTP = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
    private static final Map<UUID, TextureProp> CACHE = new ConcurrentHashMap<UUID, TextureProp>();

    public static TextureProp getSignedTexture(UUID uuid) {
        TextureProp cached = CACHE.get(uuid);
        if (cached != null) {
            return cached;
        }
        try {
            String undashed = uuid.toString().replace("-", "");
            URI uri = URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + undashed + "?unsigned=false");
            HttpRequest req = HttpRequest.newBuilder(uri).timeout(Duration.ofSeconds(8L)).header("Accept", "application/json").GET().build();
            HttpResponse<String> resp = HTTP.send(req, HttpResponse.BodyHandlers.ofString());
            if (resp.statusCode() != 200) {
                return null;
            }
            JsonObject obj = JsonParser.parseString((String)resp.body()).getAsJsonObject();
            JsonArray props = obj.getAsJsonArray("properties");
            if (props == null) {
                return null;
            }
            for (JsonElement el : props) {
                JsonObject p = el.getAsJsonObject();
                if (!"textures".equals(p.get("name").getAsString())) continue;
                String value = p.get("value").getAsString();
                String sig = p.has("signature") ? p.get("signature").getAsString() : null;
                TextureProp tp = new TextureProp(value, sig);
                CACHE.put(uuid, tp);
                return tp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public record TextureProp(String value, String signature) {
    }
}

