/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.listeners;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.gui.TeleporterGUI;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SpectatorBypassListener
implements Listener {
    private final MinecraftHelden plugin;

    public SpectatorBypassListener(MinecraftHelden plugin) {
        this.plugin = plugin;
    }

    private boolean isBypass(Player p) {
        return this.plugin.spectatorBypass().isBypassing(p.getUniqueId());
    }

    private boolean isTeleporter(ItemStack it) {
        return it != null && it.getType() == Material.COMPASS && it.hasItemMeta() && TeleporterGUI.ITEM_NAME_TELEPORTER.equals(it.getItemMeta().getDisplayName());
    }

    private boolean isLobby(ItemStack it) {
        return it != null && it.getType() == Material.NETHER_STAR && it.hasItemMeta() && TeleporterGUI.ITEM_NAME_LOBBY.equals(it.getItemMeta().getDisplayName());
    }

    private boolean isDiscord(ItemStack it) {
        return it != null && it.getType() == Material.PAPER && it.hasItemMeta() && TeleporterGUI.ITEM_NAME_DISCORD.equals(it.getItemMeta().getDisplayName());
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player viewer = e.getPlayer();
        if (this.plugin.spectatorBypass().hasBypassFlag(viewer)) {
            this.plugin.spectatorBypass().apply(viewer);
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.spectatorBypass().hideAllBypassersFrom(viewer));
        if (this.plugin.spectatorBypass().isBypassing(viewer.getUniqueId())) {
            viewer.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, false, false, false));
            viewer.setAllowFlight(true);
            viewer.setFlying(true);
            if (viewer.getGameMode() == GameMode.SPECTATOR) {
                viewer.setGameMode(GameMode.SURVIVAL);
            }
            TeleporterGUI.giveAllHotbarItems(viewer);
            viewer.sendActionBar((Component)Component.text((String)"\u00a77\u00a7lZUSCHAUER"));
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        Player viewer = e.getPlayer();
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            this.plugin.spectatorBypass().hideAllBypassersFrom(viewer);
            if (this.isBypass(viewer)) {
                TeleporterGUI.giveAllHotbarItems(viewer);
                viewer.sendActionBar((Component)Component.text((String)"\u00a77\u00a7lZUSCHAUER"));
            }
        });
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent e) {
        Player viewer = e.getPlayer();
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.spectatorBypass().hideAllBypassersFrom(viewer));
    }

    @EventHandler
    public void onAnyDamage(EntityDamageEvent e) {
        Player p;
        Entity entity = e.getEntity();
        if (entity instanceof Player && this.isBypass(p = (Player)entity)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onAttack(EntityDamageByEntityEvent e) {
        Player ep;
        Player dp;
        Entity damager = e.getDamager();
        Entity entity = e.getEntity();
        if (damager instanceof Player && this.isBypass(dp = (Player)damager) || entity instanceof Player && this.isBypass(ep = (Player)entity)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBreak(BlockBreakEvent e) {
        if (this.isBypass(e.getPlayer())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent e) {
        if (this.isBypass(e.getPlayer())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        if (this.isBypass(e.getPlayer())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        if (this.isBypass(e.getPlayer())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPickup(EntityPickupItemEvent e) {
        Player p;
        LivingEntity entity = e.getEntity();
        if (entity instanceof Player && this.isBypass(p = (Player)entity)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onAttemptPickup(PlayerAttemptPickupItemEvent e) {
        if (this.isBypass(e.getPlayer())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onSwap(PlayerSwapHandItemsEvent e) {
        if (this.isBypass(e.getPlayer())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        Player p;
        HumanEntity whoClicked = e.getWhoClicked();
        if (whoClicked instanceof Player && this.isBypass(p = (Player)whoClicked)) {
            int slot = e.getSlot();
            ItemStack cur = e.getCurrentItem();
            ItemStack cursor = e.getCursor();
            if (slot == 0 || slot == 7 || slot == 8 || this.isTeleporter(cur) || this.isLobby(cur) || this.isDiscord(cur) || this.isTeleporter(cursor) || this.isLobby(cursor) || this.isDiscord(cursor)) {
                e.setCancelled(true);
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> TeleporterGUI.giveAllHotbarItems(p));
            }
        }
    }

    @EventHandler
    public void onDrag(InventoryDragEvent e) {
        Set slots;
        Player p;
        HumanEntity whoClicked = e.getWhoClicked();
        if (whoClicked instanceof Player && this.isBypass(p = (Player)whoClicked) && ((slots = e.getRawSlots()).contains(0) || slots.contains(7) || slots.contains(8))) {
            e.setCancelled(true);
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> TeleporterGUI.giveAllHotbarItems(p));
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        if (!this.isBypass(p)) {
            return;
        }
        if (!p.getAllowFlight()) {
            p.setAllowFlight(true);
        }
        p.sendActionBar((Component)Component.text((String)"\u00a77\u00a7lZUSCHAUER"));
        ItemStack s0 = p.getInventory().getItem(0);
        ItemStack s2 = p.getInventory().getItem(7);
        ItemStack s3 = p.getInventory().getItem(8);
        if (!(this.isTeleporter(s0) && this.isLobby(s2) && this.isDiscord(s3))) {
            TeleporterGUI.giveAllHotbarItems(p);
        }
        if (!(this.isTeleporter(s0) && this.isLobby(s2) && this.isDiscord(s3))) {
            TeleporterGUI.giveAllHotbarItems(p);
        }
        if (e.getTo() != null && e.getTo().getY() < 0.0) {
            Location to = e.getTo().clone();
            to.setY(0.0);
            e.setTo(to);
        }
    }

    @EventHandler
    public void onSpectateTeleport(PlayerTeleportEvent e) {
        Player p = e.getPlayer();
        if (this.isBypass(p) && e.getCause() == PlayerTeleportEvent.TeleportCause.SPECTATE) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onGameModeChange(PlayerGameModeChangeEvent e) {
        Player p = e.getPlayer();
        if (this.isBypass(p) && e.getNewGameMode() == GameMode.SPECTATOR) {
            e.setCancelled(true);
            if (p.getGameMode() == GameMode.SPECTATOR) {
                p.setGameMode(GameMode.SURVIVAL);
            }
        }
    }
}

