/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.blocker;

import de.scholle.minecrafthelden.MinecraftHelden;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;

public class MendingEnchantBlocker
implements Listener {
    private final MinecraftHelden plugin;

    public MendingEnchantBlocker(MinecraftHelden plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent event) {
        boolean allowMending = this.plugin.getConfig().getBoolean("allow-mending", false);
        if (allowMending) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        if (event.getEnchantsToAdd().containsKey(Enchantment.MENDING)) {
            event.getEnchantsToAdd().remove(Enchantment.MENDING);
            if (event.getEnchanter() != null) {
                event.getEnchanter().sendMessage("\u00a7cMending ist deaktiviert!");
            }
        }
    }

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        boolean allowMending = this.plugin.getConfig().getBoolean("allow-mending", false);
        if (allowMending) {
            return;
        }
        AnvilInventory inventory = event.getInventory();
        ItemStack first = inventory.getItem(0);
        ItemStack second = inventory.getItem(1);
        if (first == null || second == null) {
            return;
        }
        if (second.containsEnchantment(Enchantment.MENDING)) {
            event.setResult(null);
        }
    }

    @EventHandler
    public void onAnvilClick(InventoryClickEvent event) {
        boolean allowMending = this.plugin.getConfig().getBoolean("allow-mending", false);
        if (allowMending) {
            return;
        }
        if (event.getInventory().getType() != InventoryType.ANVIL) {
            return;
        }
        if (event.getRawSlot() != 2) {
            return;
        }
        ItemStack result = event.getCurrentItem();
        if (result == null) {
            return;
        }
        if (result.containsEnchantment(Enchantment.MENDING)) {
            event.setCancelled(true);
            HumanEntity humanEntity = event.getWhoClicked();
            if (humanEntity instanceof Player) {
                Player player = (Player)humanEntity;
                player.sendMessage("\u00a7cMending ist deaktiviert!");
            }
        }
    }
}

