/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.listeners;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.manager.CountdownManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class SpawnScatterListener
implements Listener {
    private final MinecraftHelden plugin;

    public SpawnScatterListener(MinecraftHelden plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        try {
            if (this.plugin.spectatorBypass() != null && this.plugin.spectatorBypass().isBypassing(p.getUniqueId())) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!p.hasPlayedBefore()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                World w = CountdownManager.mainWorld();
                Location loc = this.plugin.countdown().randomSafeLocation(w, 2500, 12);
                if (loc != null) {
                    this.plugin.countdown().teleportAndSettle(p, loc, true);
                }
            }, 5L);
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        Player p = e.getPlayer();
        try {
            if (this.plugin.spectatorBypass() != null && this.plugin.spectatorBypass().isBypassing(p.getUniqueId())) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (e.isBedSpawn() || e.isAnchorSpawn()) {
            return;
        }
        World w = CountdownManager.mainWorld();
        Location loc = this.plugin.countdown().randomSafeLocation(w, 2500, 12);
        if (loc == null) {
            return;
        }
        e.setRespawnLocation(loc);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.countdown().teleportAndSettle(p, loc, false), 1L);
    }
}

