/*
 * Decompiled with CFR 0.152.
 */
package smp.mace.Cores;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import smp.mace.CustomMace.End;
import smp.mace.Util.CooldownManager;

public class BoxedCore
implements Listener {
    private JavaPlugin plugin;
    private End end;
    private CooldownManager cooldownManager = new CooldownManager();
    private boolean boxedCoreCrafted;
    private boolean endMaceCrafted;
    private boolean bossbar = true;

    public BoxedCore(JavaPlugin plugin) {
        this.plugin = plugin;
        this.end = new End(this.cooldownManager, plugin);
        this.addBoxedCoreRecipe();
        this.loadCraftingStatus();
    }

    public ItemStack createBoxedCore() {
        ItemStack BoxedCore2 = new ItemStack(Material.HEAVY_CORE);
        ItemMeta coreMeta = BoxedCore2.getItemMeta();
        if (coreMeta != null) {
            coreMeta.setCustomModelData(Integer.valueOf(3));
            BoxedCore2.setItemMeta(coreMeta);
        }
        return BoxedCore2;
    }

    public void addBoxedCoreRecipe() {
        ShapedRecipe BoxedRecipe = new ShapedRecipe(new NamespacedKey((Plugin)this.plugin, "boxedRecipe"), this.createBoxedCore());
        BoxedRecipe.shape(new String[]{"aaa", "bcb", "aaa"});
        BoxedRecipe.setIngredient('a', Material.SHULKER_SHELL);
        BoxedRecipe.setIngredient('b', Material.DRAGON_BREATH);
        BoxedRecipe.setIngredient('c', Material.DRAGON_EGG);
        Bukkit.addRecipe((Recipe)BoxedRecipe);
        ShapelessRecipe EndMace = new ShapelessRecipe(new NamespacedKey((Plugin)this.plugin, "endMace"), this.end.createEndMace());
        EndMace.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(this.createBoxedCore()));
        EndMace.addIngredient(1, Material.BREEZE_ROD);
        Bukkit.addRecipe((Recipe)EndMace);
    }

    private void loadCraftingStatus() {
        this.boxedCoreCrafted = this.plugin.getConfig().getBoolean("boxedCoreCrafted", false);
        this.endMaceCrafted = this.plugin.getConfig().getBoolean("endMaceCrafted", false);
    }

    private void saveCraftingStatus() {
        this.plugin.getConfig().set("boxedCoreCrafted", (Object)this.boxedCoreCrafted);
        this.plugin.getConfig().set("endMaceCrafted", (Object)this.endMaceCrafted);
        this.plugin.saveConfig();
    }

    @EventHandler
    public void BoxedCoreRecipe(CraftItemEvent event) {
        ItemStack craftedItem = event.getCurrentItem();
        if (this.isBoxedCore(craftedItem)) {
            if (this.boxedCoreCrafted) {
                event.setCancelled(true);
                event.getWhoClicked().sendMessage("Sorry too slow, it's already crafted ;) ");
            } else {
                this.boxedCoreCrafted = true;
                this.saveCraftingStatus();
                Bukkit.removeRecipe((NamespacedKey)new NamespacedKey((Plugin)this.plugin, "boxedRecipe"));
                Player player = (Player)event.getWhoClicked();
                player.sendMessage("Congrats, now go craft the Mace");
                this.showCraftingBossBar(player);
            }
        }
    }

    @EventHandler
    public void EndMaceCraft(CraftItemEvent event) {
        if (event.getCurrentItem().equals((Object)this.end.createEndMace())) {
            if (this.endMaceCrafted) {
                event.setCancelled(true);
                event.getWhoClicked().sendMessage("Sorry too slow, it's already crafted ;) ");
            } else {
                this.endMaceCrafted = true;
                Bukkit.removeRecipe((NamespacedKey)new NamespacedKey((Plugin)this.plugin, "endMace"));
                Player player = (Player)event.getWhoClicked();
                player.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Congrats");
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.LIGHT_PURPLE) + player.getName() + " Has Crafted The End Mace"));
                this.showCraftingBossBar(player);
            }
        }
    }

    private boolean isBoxedCore(ItemStack item) {
        if (item != null && item.getType() == Material.HEAVY_CORE) {
            ItemMeta meta = item.getItemMeta();
            return meta != null && meta.getCustomModelData() == 3;
        }
        return false;
    }

    private void showCraftingBossBar(final Player player) {
        if (this.bossbar) {
            new BukkitRunnable(this){
                double progress = 1.0;
                int craftingDuration = 36000;
                final BossBar bossBar = Bukkit.createBossBar((String)"Crafting End Mace...", (BarColor)BarColor.RED, (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]);

                public void run() {
                    if (this.progress <= 0.0) {
                        this.bossBar.removeAll();
                        this.cancel();
                        return;
                    }
                    Location updatedLocation = player.getLocation();
                    this.bossBar.setTitle("End Mace is being crafted at (" + updatedLocation.getBlockX() + ", " + updatedLocation.getBlockY() + ", " + updatedLocation.getBlockZ() + ")");
                    this.bossBar.addPlayer(player);
                    this.progress -= 1.0 / ((double)this.craftingDuration / 20.0);
                    this.bossBar.setProgress(Math.max(0.0, this.progress));
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
            this.bossbar = false;
        }
    }
}

