/*
 * Decompiled with CFR 0.152.
 */
package smp.mace.Cores;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import smp.mace.CustomMace.Breezy;
import smp.mace.Util.CooldownManager;

public class BreezeCore
implements Listener {
    private JavaPlugin plugin;
    private CooldownManager cooldownManager = new CooldownManager();
    private Breezy breeze;
    private boolean breezeMace;
    private boolean bossbar = true;

    public BreezeCore(JavaPlugin plugin) {
        this.plugin = plugin;
        this.breeze = new Breezy(this.cooldownManager, plugin);
        this.BreezeMaceRecipe();
        this.loadCraftingStatus();
    }

    public ItemStack createBreezeCore() {
        ItemStack BreezeCore2 = new ItemStack(Material.HEAVY_CORE);
        ItemMeta coreMeta = BreezeCore2.getItemMeta();
        if (coreMeta != null) {
            coreMeta.setCustomModelData(Integer.valueOf(1));
            BreezeCore2.setItemMeta(coreMeta);
        }
        return BreezeCore2;
    }

    public void BreezeMaceRecipe() {
        ShapelessRecipe BreezeMace = new ShapelessRecipe(new NamespacedKey((Plugin)this.plugin, "breezeMace"), this.breeze.createBreezyMace());
        BreezeMace.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(this.createBreezeCore()));
        BreezeMace.addIngredient(1, Material.BREEZE_ROD);
        Bukkit.addRecipe((Recipe)BreezeMace);
    }

    private void loadCraftingStatus() {
        this.breezeMace = this.plugin.getConfig().getBoolean("breezeMaceCrafted", false);
    }

    private void saveCraftingStatus() {
        this.plugin.getConfig().set("breezeMaceCrafted", (Object)this.breezeMace);
        this.plugin.saveConfig();
    }

    @EventHandler
    public void BreezeMaceCraft(CraftItemEvent event) {
        if (event.getCurrentItem().equals((Object)this.breeze.createBreezyMace())) {
            if (this.breezeMace) {
                event.setCancelled(true);
                event.getWhoClicked().sendMessage("Sorry too slow It's already Crafted ;) ");
            } else {
                this.breezeMace = true;
                this.saveCraftingStatus();
                Bukkit.removeRecipe((NamespacedKey)new NamespacedKey((Plugin)this.plugin, "breezeMace"));
                Player player = (Player)event.getWhoClicked();
                this.showCraftingBossBar(player);
            }
        }
    }

    private void showCraftingBossBar(final Player player) {
        if (this.bossbar) {
            new BukkitRunnable(this){
                double progress = 1.0;
                int craftingDuration = 36000;
                final BossBar bossBar = Bukkit.createBossBar((String)"Crafting Breeze Mace...", (BarColor)BarColor.RED, (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]);

                public void run() {
                    if (this.progress <= 0.0) {
                        this.bossBar.removeAll();
                        this.cancel();
                        return;
                    }
                    Location updatedLocation = player.getLocation();
                    this.bossBar.setTitle("Breeze Mace is being crafted at (" + updatedLocation.getBlockX() + ", " + updatedLocation.getBlockY() + ", " + updatedLocation.getBlockZ() + ")");
                    this.bossBar.addPlayer(player);
                    this.progress -= 1.0 / ((double)this.craftingDuration / 20.0);
                    this.bossBar.setProgress(Math.max(0.0, this.progress));
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
            this.bossbar = false;
        }
    }
}

