/*
 * Decompiled with CFR 0.152.
 */
package smp.mace.Cores;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import smp.mace.CustomMace.Dense;
import smp.mace.Util.CooldownManager;

public class DenseCore
implements Listener {
    private JavaPlugin plugin;
    private CooldownManager cooldownManager = new CooldownManager();
    private Dense dense;
    private boolean denseMace;
    private boolean bossbar = true;

    public DenseCore(JavaPlugin plugin) {
        this.plugin = plugin;
        this.dense = new Dense(this.cooldownManager, plugin);
        this.DenseMaceRecipe();
        this.loadCraftingStatus();
    }

    public ItemStack createDenseCore() {
        ItemStack DenseCore2 = new ItemStack(Material.HEAVY_CORE);
        ItemMeta coreMeta = DenseCore2.getItemMeta();
        if (coreMeta != null) {
            coreMeta.setCustomModelData(Integer.valueOf(2));
            DenseCore2.setItemMeta(coreMeta);
        }
        return DenseCore2;
    }

    public void DenseMaceRecipe() {
        ShapelessRecipe DenseMace = new ShapelessRecipe(new NamespacedKey((Plugin)this.plugin, "denseMace"), this.dense.createDenseMace());
        DenseMace.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(this.createDenseCore()));
        DenseMace.addIngredient(1, Material.BREEZE_ROD);
        Bukkit.addRecipe((Recipe)DenseMace);
    }

    private void loadCraftingStatus() {
        this.denseMace = this.plugin.getConfig().getBoolean("denseMaceCrafted", false);
    }

    private void saveCraftingStatus() {
        this.plugin.getConfig().set("denseMaceCrafted", (Object)this.denseMace);
        this.plugin.saveConfig();
    }

    @EventHandler
    public void DenseMaceCraft(CraftItemEvent event) {
        if (event.getCurrentItem().equals((Object)this.dense.createDenseMace())) {
            if (this.denseMace) {
                event.setCancelled(true);
                event.getWhoClicked().sendMessage("Sorry too slow, It's already crafted ;) ");
            } else {
                this.denseMace = true;
                this.saveCraftingStatus();
                Bukkit.removeRecipe((NamespacedKey)new NamespacedKey((Plugin)this.plugin, "denseMace"));
                Player player = (Player)event.getWhoClicked();
                this.showCraftingBossBar(player);
            }
        }
    }

    private void showCraftingBossBar(final Player player) {
        if (this.bossbar) {
            new BukkitRunnable(this){
                double progress = 1.0;
                int craftingDuro = 36000;
                final BossBar bossBar = Bukkit.createBossBar((String)"Crafting Dense Mace...", (BarColor)BarColor.RED, (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]);

                public void run() {
                    if (this.progress <= 0.0) {
                        this.bossBar.removeAll();
                        this.cancel();
                        return;
                    }
                    Location updatedLocation = player.getLocation();
                    this.bossBar.setTitle("Dense Mace is being crafted at (" + updatedLocation.getBlockX() + ", " + updatedLocation.getBlockY() + ", " + updatedLocation.getBlockZ() + ")");
                    this.bossBar.addPlayer(player);
                    this.progress -= 1.0 / ((double)this.craftingDuro / 20.0);
                    this.bossBar.setProgress(Math.max(0.0, this.progress));
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
            this.bossbar = false;
        }
    }
}

