/*
 * Decompiled with CFR 0.152.
 */
package smp.mace.Cores;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import smp.mace.CustomMace.Light;
import smp.mace.Util.CooldownManager;

public class LightCore
implements Listener {
    private Light light;
    private CooldownManager cooldownManager = new CooldownManager();
    private JavaPlugin plugin;
    private boolean lightMace;
    private boolean bossbar = true;

    public LightCore(JavaPlugin plugin) {
        this.plugin = plugin;
        this.light = new Light(this.cooldownManager, plugin);
        this.lightMaceRecipe();
        this.loadCraftingStatus();
    }

    public ItemStack createLightCore() {
        ItemStack LightCore2 = new ItemStack(Material.HEAVY_CORE);
        ItemMeta coreMeta = LightCore2.getItemMeta();
        if (coreMeta != null) {
            coreMeta.setCustomModelData(Integer.valueOf(6));
            LightCore2.setItemMeta(coreMeta);
        }
        return LightCore2;
    }

    public void lightMaceRecipe() {
        ShapelessRecipe lightMace = new ShapelessRecipe(new NamespacedKey((Plugin)this.plugin, "lightMace"), this.light.createLightMace());
        lightMace.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(this.createLightCore()));
        lightMace.addIngredient(1, Material.BREEZE_ROD);
        Bukkit.addRecipe((Recipe)lightMace);
    }

    private void loadCraftingStatus() {
        this.lightMace = this.plugin.getConfig().getBoolean("lightMaceCrafted", false);
    }

    private void saveCraftingStatus() {
        this.plugin.getConfig().set("lightMaceCrafted", (Object)this.lightMace);
        this.plugin.saveConfig();
    }

    @EventHandler
    public void lightMaceCraft(CraftItemEvent event) {
        if (event.getCurrentItem().equals((Object)this.light.createLightMace())) {
            if (this.lightMace) {
                event.setCancelled(true);
                event.getWhoClicked().sendMessage("Sorry, too slow. It's already crafted. ;) ");
            } else {
                this.lightMace = true;
                this.saveCraftingStatus();
                Bukkit.removeRecipe((NamespacedKey)new NamespacedKey((Plugin)this.plugin, "lightMace"));
                Player player = (Player)event.getWhoClicked();
                this.showCraftingBossBar(player);
            }
        }
    }

    private void showCraftingBossBar(final Player player) {
        if (this.bossbar) {
            new BukkitRunnable(this){
                double progress = 1.0;
                int craftingDuration = 36000;
                final BossBar bossBar = Bukkit.createBossBar((String)"Crafting Light Mace...", (BarColor)BarColor.RED, (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]);

                public void run() {
                    if (this.progress <= 0.0) {
                        this.bossBar.removeAll();
                        this.cancel();
                        return;
                    }
                    Location updatedLocation = player.getLocation();
                    this.bossBar.setTitle("Light Mace is being crafted at (" + updatedLocation.getBlockX() + ", " + updatedLocation.getBlockY() + ", " + updatedLocation.getBlockZ() + ")");
                    this.bossBar.addPlayer(player);
                    this.progress -= 1.0 / ((double)this.craftingDuration / 20.0);
                    this.bossBar.setProgress(Math.max(0.0, this.progress));
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
            this.bossbar = false;
        }
    }
}

