/*
 * Decompiled with CFR 0.152.
 */
package smp.mace.Cores;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import smp.mace.CustomMace.Warden;
import smp.mace.Util.CooldownManager;

public class WardenCore
implements Listener {
    private Warden warden;
    private CooldownManager cooldownManager = new CooldownManager();
    private JavaPlugin plugin;
    private boolean wardenMace;
    private boolean bossbar = true;

    public WardenCore(JavaPlugin plugin) {
        this.plugin = plugin;
        this.warden = new Warden(this.cooldownManager, plugin);
        this.wardenMaceRecipe();
        this.loadCraftingStatus();
    }

    public ItemStack createWardenCore() {
        ItemStack WardenCore2 = new ItemStack(Material.HEAVY_CORE);
        ItemMeta coreMeta = WardenCore2.getItemMeta();
        if (coreMeta != null) {
            coreMeta.setCustomModelData(Integer.valueOf(9));
            WardenCore2.setItemMeta(coreMeta);
        }
        return WardenCore2;
    }

    public void wardenMaceRecipe() {
        ShapelessRecipe WardenMace = new ShapelessRecipe(new NamespacedKey((Plugin)this.plugin, "wardenMace"), this.warden.createWardenMace());
        WardenMace.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(this.createWardenCore()));
        WardenMace.addIngredient(1, Material.BREEZE_ROD);
        Bukkit.addRecipe((Recipe)WardenMace);
    }

    private void loadCraftingStatus() {
        this.wardenMace = this.plugin.getConfig().getBoolean("wardenMaceCrafted", false);
    }

    private void saveCraftingStatus() {
        this.plugin.getConfig().set("wardenMaceCrafted", (Object)this.wardenMace);
        this.plugin.saveConfig();
    }

    @EventHandler
    public void WardenMaceCraft(CraftItemEvent event) {
        if (event.getCurrentItem().equals((Object)this.warden.createWardenMace())) {
            if (this.wardenMace) {
                event.setCancelled(true);
                event.getWhoClicked().sendMessage("Sorry, too slow. It's already crafted. ;) ");
            } else {
                this.wardenMace = true;
                this.saveCraftingStatus();
                Bukkit.removeRecipe((NamespacedKey)new NamespacedKey((Plugin)this.plugin, "wardenMace"));
                Player player = (Player)event.getWhoClicked();
                this.showCraftingBossBar(player);
            }
        }
    }

    private void showCraftingBossBar(final Player player) {
        if (this.bossbar) {
            new BukkitRunnable(this){
                double progress = 1.0;
                int craftingDuration = 36000;
                final BossBar bossBar = Bukkit.createBossBar((String)"Crafting Warden Mace...", (BarColor)BarColor.RED, (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]);

                public void run() {
                    if (this.progress <= 0.0) {
                        this.bossBar.removeAll();
                        this.cancel();
                        return;
                    }
                    Location updatedLocation = player.getLocation();
                    this.bossBar.setTitle("Warden Mace is being crafted at (" + updatedLocation.getBlockX() + ", " + updatedLocation.getBlockY() + ", " + updatedLocation.getBlockZ() + ")");
                    this.bossBar.addPlayer(player);
                    this.progress -= 1.0 / ((double)this.craftingDuration / 20.0);
                    this.bossBar.setProgress(Math.max(0.0, this.progress));
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
            this.bossbar = false;
        }
    }
}

