/*
 * Decompiled with CFR 0.152.
 */
package smp.mace.CustomMace;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;
import smp.mace.Util.CooldownManager;

public class Breezy
implements Listener {
    private final CooldownManager cooldown;
    private JavaPlugin plugin;

    public Breezy(CooldownManager cooldown, JavaPlugin plugin) {
        this.cooldown = cooldown;
        this.plugin = plugin;
    }

    public ItemStack createBreezyMace() {
        ItemStack breezyMace = new ItemStack(Material.MACE);
        ItemMeta meta = breezyMace.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.WHITE) + "Breezy Mace");
            meta.setCustomModelData(Integer.valueOf(1233));
            meta.setMaxStackSize(Integer.valueOf(1));
            meta.setUnbreakable(true);
            meta.setFireResistant(true);
            meta.addEnchant(Enchantment.BREACH, 5, false);
            meta.addEnchant(Enchantment.WIND_BURST, 1, false);
            breezyMace.setItemMeta(meta);
        }
        return breezyMace;
    }

    public void handleAbility(Player player) {
        if (!this.cooldown.isOnCooldown(player, "breeze")) {
            Vector velocity = player.getVelocity();
            velocity.setY(3.5);
            player.setVelocity(velocity);
            this.cooldown.startCooldown(player, "breeze", 60000L);
        } else {
            long remainingTime = this.cooldown.getCooldown(player, "breeze");
            player.sendMessage("Breezy Mace is on cooldown for " + remainingTime / 1000L + " more seconds!");
        }
    }

    @EventHandler
    public void refillWC(PlayerInteractEvent event) {
        if (this.hasItem(event.getPlayer(), Material.MACE, 1233)) {
            Player player = event.getPlayer();
            ItemStack item = event.getItem();
            if (item != null && item.getType() == Material.WIND_CHARGE && item.getItemMeta() != null) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    boolean hasWindCharge = false;
                    for (ItemStack i : player.getInventory().getContents()) {
                        if (i == null || i.getType() != Material.WIND_CHARGE) continue;
                        hasWindCharge = true;
                        break;
                    }
                    if (!hasWindCharge) {
                        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.WIND_CHARGE, 1)});
                    }
                }, 1L);
            }
        }
    }

    @EventHandler
    public void cancelFallDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.hasItem(player, Material.MACE, 1233) && event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            event.setCancelled(true);
        }
    }

    public boolean hasItem(Player player, Material material, int modelData) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material || !this.hasSpecificMace(item, modelData).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean hasSpecificMace(ItemStack item, int modelData) {
        return item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == modelData;
    }
}

