/*
 * Decompiled with CFR 0.152.
 */
package smp.mace.CustomMace;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SmallFireball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import smp.mace.Util.CooldownManager;

public class Dense
implements Listener {
    private final CooldownManager cooldown;
    private final JavaPlugin plugin;
    private final Set<Player> disabledShields = new HashSet<Player>();

    public Dense(CooldownManager cooldown, JavaPlugin plugin) {
        this.cooldown = cooldown;
        this.plugin = plugin;
    }

    public ItemStack createDenseMace() {
        ItemStack denseMace = new ItemStack(Material.MACE);
        ItemMeta meta = denseMace.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.DARK_GRAY) + "Dense Mace");
            meta.setCustomModelData(Integer.valueOf(1231));
            meta.setMaxStackSize(Integer.valueOf(1));
            meta.setUnbreakable(true);
            meta.setFireResistant(true);
            meta.addEnchant(Enchantment.BREACH, 5, false);
            meta.addEnchant(Enchantment.WIND_BURST, 1, false);
            denseMace.setItemMeta(meta);
        }
        return denseMace;
    }

    public void handleAbility(Player player) {
        if (!this.cooldown.isOnCooldown(player, "dense_mace")) {
            this.disableShieldNearbyPlayers(player, 20.0, 400);
            this.cooldown.startCooldown(player, "dense_mace", 120000L);
        } else {
            long remainingTime = this.cooldown.getCooldown(player, "dense_mace");
            player.sendMessage("Dense Mace is on cooldown for " + remainingTime / 1000L + " more seconds!");
        }
    }

    @EventHandler
    public void onMaceHit(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (!this.hasSpecificMace(item, 1231).booleanValue()) {
            return;
        }
        double newDamage = event.getDamage() * 2.0;
        event.setDamage(newDamage);
    }

    @EventHandler
    public void onWindChargeCollide(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof SmallFireball)) {
            return;
        }
        SmallFireball fireball = (SmallFireball)entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player player = (Player)entity2;
        double customDamage = 0.1;
        event.setDamage(customDamage);
    }

    private void disableShieldNearbyPlayers(Player activator, double radius, int durationTicks) {
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (target.equals((Object)activator) || !(target.getLocation().distance(activator.getLocation()) <= radius)) continue;
            this.forceLowerShield(target);
            this.disableShield(target, durationTicks);
        }
    }

    private void forceLowerShield(final Player player) {
        if (player.isBlocking() && (player.getInventory().getItemInOffHand().getType() == Material.SHIELD || player.getInventory().getItemInMainHand().getType() == Material.SHIELD)) {
            final ItemStack offhandItem = player.getInventory().getItemInOffHand();
            final ItemStack mainhandItem = player.getInventory().getItemInMainHand();
            if (mainhandItem.getType() == Material.SHIELD) {
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
            }
            if (offhandItem.getType() == Material.SHIELD) {
                player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
            }
            new BukkitRunnable(this){

                public void run() {
                    if (mainhandItem.getType() == Material.SHIELD) {
                        player.getInventory().setItemInMainHand(mainhandItem);
                    }
                    if (offhandItem.getType() == Material.SHIELD) {
                        player.getInventory().setItemInOffHand(offhandItem);
                    }
                    player.sendMessage("\u00a7aYour shield is re-enabled! You need to right-click to block again.");
                }
            }.runTaskLater((Plugin)this.plugin, 50L);
        }
    }

    private void disableShield(final Player player, int durationTicks) {
        if (this.disabledShields.contains(player)) {
            return;
        }
        this.disabledShields.add(player);
        player.setCooldown(Material.SHIELD, durationTicks);
        player.sendMessage("\u00a7cYou cannot use your shield for " + durationTicks / 20 + " seconds!");
        new BukkitRunnable(){

            public void run() {
                Dense.this.disabledShields.remove(player);
                player.setCooldown(Material.SHIELD, 0);
                player.sendMessage("\u00a7aYour shield is now re-enabled!");
            }
        }.runTaskLater((Plugin)this.plugin, (long)durationTicks);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getAction().toString().contains("RIGHT_CLICK") && (player.getInventory().getItemInOffHand().getType() == Material.SHIELD || player.getInventory().getItemInMainHand().getType() == Material.SHIELD)) {
            this.forceLowerShield(player);
        }
    }

    public Boolean hasSpecificMace(ItemStack item, int modelData) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == modelData;
    }
}

