/*
 * Decompiled with CFR 0.152.
 */
package smp.mace.CustomMace;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import smp.mace.Util.CooldownManager;

public class End
implements Listener {
    private final CooldownManager cooldown;
    private final Map<UUID, Boolean> levitationState = new HashMap<UUID, Boolean>();
    private JavaPlugin plugin;
    private boolean newState;

    public End(CooldownManager cooldown, JavaPlugin plugin) {
        this.cooldown = cooldown;
        this.plugin = plugin;
    }

    public ItemStack createEndMace() {
        ItemStack endMace = new ItemStack(Material.MACE);
        ItemMeta meta = endMace.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.GOLD) + "End Mace");
            meta.setCustomModelData(Integer.valueOf(1237));
            meta.setMaxStackSize(Integer.valueOf(1));
            meta.setUnbreakable(true);
            meta.setFireResistant(true);
            meta.addEnchant(Enchantment.BREACH, 5, false);
            meta.addEnchant(Enchantment.WIND_BURST, 1, false);
            endMace.setItemMeta(meta);
        }
        return endMace;
    }

    public void handleAbility(Player player) {
        this.newState = this.levitationState.getOrDefault(player.getUniqueId(), false) == false;
        this.levitationState.put(player.getUniqueId(), this.newState);
        if (this.newState) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, -1, 1));
        } else {
            player.removePotionEffect(PotionEffectType.LEVITATION);
        }
    }

    @EventHandler
    public void refillEP(PlayerInteractEvent event) {
        if (this.hasItem(event.getPlayer(), Material.MACE, 1237)) {
            Player player = event.getPlayer();
            ItemStack item = event.getItem();
            if (item != null && item.getType() == Material.ENDER_PEARL && item.getItemMeta() != null) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    boolean hasEP = false;
                    for (ItemStack i : player.getInventory().getContents()) {
                        if (i == null || i.getType() != Material.ENDER_PEARL) continue;
                        hasEP = true;
                        break;
                    }
                    if (!hasEP) {
                        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.ENDER_PEARL, 1)});
                    }
                }, 1L);
            }
        }
    }

    @EventHandler
    public void onEndermanTarget(EntityTargetEvent event) {
        Entity entity;
        Entity entity2 = event.getEntity();
        if (entity2.getType() == EntityType.ENDERMAN && (entity = event.getTarget()) instanceof Player) {
            Player player = (Player)entity;
            if (!this.hasItem(player, Material.MACE, 1237)) {
                return;
            }
            event.setCancelled(true);
        }
    }

    public boolean hasItem(Player player, Material material, int modelData) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material || !this.hasSpecificMace(item, modelData).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean hasSpecificMace(ItemStack item, int modelData) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == modelData;
    }
}

