/*
 * Decompiled with CFR 0.152.
 */
package smp.mace.CustomMace;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import smp.mace.Util.CooldownManager;

public class Flames
implements Listener {
    private final CooldownManager cooldown;
    private JavaPlugin plugin;

    public Flames(CooldownManager cooldown, JavaPlugin plugin) {
        this.cooldown = cooldown;
        this.plugin = plugin;
        this.startFireResCheck();
    }

    public ItemStack createFlameMace() {
        ItemStack flameMace = new ItemStack(Material.MACE);
        ItemMeta meta = flameMace.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.RED) + "Flame Mace");
            meta.setCustomModelData(Integer.valueOf(1234));
            meta.setMaxStackSize(Integer.valueOf(1));
            meta.setUnbreakable(true);
            meta.setFireResistant(true);
            meta.addEnchant(Enchantment.BREACH, 5, false);
            meta.addEnchant(Enchantment.WIND_BURST, 1, false);
            flameMace.setItemMeta(meta);
        }
        return flameMace;
    }

    public void handleAbility(Player player) {
        if (!this.cooldown.isOnCooldown(player, "flameMace")) {
            this.shootFireball(player);
            this.shootFireball(player);
            this.shootFireball(player);
            this.shootFireball(player);
            this.cooldown.startCooldown(player, "flameMace", 90000L);
        } else {
            long remainingTime = this.cooldown.getCooldown(player, "flameMace");
            player.sendMessage("Flame Mace is on cooldown for " + remainingTime / 1000L + " more seconds!");
        }
    }

    public void shootFireball(Player player) {
        Fireball fireball = (Fireball)player.launchProjectile(Fireball.class);
        fireball.setVelocity(player.getLocation().getDirection().multiply(2));
        fireball.setIsIncendiary(true);
        fireball.setYield(2.0f);
    }

    @EventHandler
    public void onFireballCollide(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Fireball)) {
            return;
        }
        Fireball fireball = (Fireball)entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player player = (Player)entity2;
        if (this.hasWindCharge(player)) {
            return;
        }
        if (fireball.getShooter() instanceof Player) {
            double customDamage = event.getDamage() * 1.5;
            event.setDamage(customDamage);
        }
    }

    private boolean hasWindCharge(Player player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != Material.WIND_CHARGE) continue;
            return true;
        }
        return false;
    }

    private LivingEntity getNearestTarget(Player player, double radius) {
        Location playerLoc = player.getLocation();
        LivingEntity nearest = null;
        double closestDistance = radius;
        for (Entity entity : player.getNearbyEntities(radius, radius, radius)) {
            double distance;
            LivingEntity target;
            if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity) instanceof Player && this.isTeammate(player, (Player)target) || !((distance = playerLoc.distanceSquared(target.getLocation())) < closestDistance)) continue;
            closestDistance = distance;
            nearest = target;
        }
        return nearest;
    }

    private boolean isTeammate(Player player, Player target) {
        return player.getScoreboard().getEntryTeam(player.getName()) != null && player.getScoreboard().getEntryTeam(player.getName()).equals((Object)target.getScoreboard().getEntryTeam(target.getName()));
    }

    public void startFireResCheck() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (Flames.this.hasItem(player, Material.MACE, 1234)) {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, -1, 0));
                        continue;
                    }
                    PotionEffect strengthEffect = player.getPotionEffect(PotionEffectType.FIRE_RESISTANCE);
                    if (strengthEffect == null || strengthEffect.getDuration() != -1) continue;
                    player.removePotionEffect(PotionEffectType.FIRE_RESISTANCE);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 100L);
    }

    public boolean hasItem(Player player, Material material, int modelData) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material || !this.hasSpecificMace(item, modelData).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean hasSpecificMace(ItemStack item, int modelData) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == modelData;
    }
}

