/*
 * Decompiled with CFR 0.152.
 */
package smp.mace.CustomMace;

import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import smp.mace.Util.CooldownManager;

public class Frozen
implements Listener {
    private final CooldownManager cooldown;
    private final HashSet<UUID> slownessAttackers = new HashSet();
    private JavaPlugin plugin;

    public Frozen(CooldownManager cooldown, JavaPlugin plugin) {
        this.cooldown = cooldown;
        this.plugin = plugin;
        this.startBlockCheck();
    }

    public ItemStack createFrozenMace() {
        ItemStack frozenMace = new ItemStack(Material.MACE);
        ItemMeta meta = frozenMace.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.BLUE) + "Frozen Mace");
            meta.setCustomModelData(Integer.valueOf(1236));
            meta.setMaxStackSize(Integer.valueOf(1));
            meta.setUnbreakable(true);
            meta.setFireResistant(true);
            meta.addEnchant(Enchantment.BREACH, 5, false);
            meta.addEnchant(Enchantment.WIND_BURST, 1, false);
            frozenMace.setItemMeta(meta);
        }
        return frozenMace;
    }

    public void handleAbility(Player player) {
        if (!this.cooldown.isOnCooldown(player, "frozen_mace")) {
            this.slownessAttackers.add(player.getUniqueId());
            this.cooldown.startCooldown(player, "frozen_mace", 300000L);
        } else {
            long remainingTime = this.cooldown.getCooldown(player, "frozen_mace");
            player.sendMessage("Frozen Mace is on cooldown for " + remainingTime / 1000L + " more seconds!");
        }
    }

    @EventHandler
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player target = (Player)entity2;
        if (this.hadSlowness(attacker)) {
            target.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 200, 9));
            attacker.sendMessage("\u00a7cYou inflicted Slowness 10 on " + target.getName() + "!");
            target.sendMessage("\u00a7cYou have been hit and received Slowness 10!");
            this.removeSlowness(attacker);
        }
    }

    public boolean hadSlowness(Player player) {
        return this.slownessAttackers.contains(player.getUniqueId());
    }

    public void removeSlowness(Player player) {
        this.slownessAttackers.remove(player.getUniqueId());
    }

    public void startBlockCheck() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    PotionEffect speedEffect;
                    if (!Frozen.this.hasItem(player, Material.MACE, 1236)) continue;
                    if (Frozen.this.isStandingOnBlock(player, Material.ICE)) {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, -1, 2));
                    }
                    if (Frozen.this.isStandingOnBlock(player, Material.ICE) || (speedEffect = player.getPotionEffect(PotionEffectType.SPEED)) == null || speedEffect.getDuration() != -1) continue;
                    player.removePotionEffect(PotionEffectType.SPEED);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private boolean isStandingOnBlock(Player player, Material blockType) {
        return player.getLocation().subtract(0.0, 1.0, 0.0).getBlock().getType() == blockType;
    }

    public boolean hasItem(Player player, Material material, int modelData) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material || !this.hasSpecificMace(item, modelData).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean hasSpecificMace(ItemStack item, int modelData) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == modelData;
    }
}

