/*
 * Decompiled with CFR 0.152.
 */
package smp.mace.CustomMace;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import smp.mace.Util.CooldownManager;

public class Light
implements Listener {
    private final CooldownManager cooldown;
    private final JavaPlugin plugin;
    private final Set<UUID> lightMaceUsers = new HashSet<UUID>();

    public Light(CooldownManager cooldown, JavaPlugin plugin) {
        this.cooldown = cooldown;
        this.plugin = plugin;
        this.startJumpCheck();
    }

    public ItemStack createLightMace() {
        ItemStack lightMace = new ItemStack(Material.MACE);
        ItemMeta meta = lightMace.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Light Mace");
            meta.setCustomModelData(Integer.valueOf(1232));
            meta.setMaxStackSize(Integer.valueOf(1));
            meta.setUnbreakable(true);
            meta.setFireResistant(true);
            meta.addEnchant(Enchantment.BREACH, 5, false);
            meta.addEnchant(Enchantment.WIND_BURST, 1, false);
            lightMace.setItemMeta(meta);
        }
        return lightMace;
    }

    public void handleAbility(Player player) {
        if (!this.cooldown.isOnCooldown(player, "light_mace")) {
            this.lightMaceUsers.add(player.getUniqueId());
            this.cooldown.startCooldown(player, "light_mace", 90000L);
        } else {
            long remainingTime = this.cooldown.getCooldown(player, "light_mace");
            player.sendMessage("Light Mace is on cooldown for " + remainingTime / 1000L + " more seconds!");
        }
    }

    @EventHandler
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player target = (Player)entity2;
        if (this.lightMaceUsers.contains(attacker.getUniqueId())) {
            this.lightMaceUsers.remove(attacker.getUniqueId());
            this.headCob(event);
        }
    }

    public void headCob(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player target = (Player)entity2;
        final Block headBlock = target.getLocation().add(0.0, 1.0, 0.0).getBlock();
        if (headBlock.getType() == Material.AIR) {
            headBlock.setType(Material.COBWEB);
        }
        new BukkitRunnable(this){

            public void run() {
                if (headBlock.getType() == Material.COBWEB) {
                    headBlock.setType(Material.AIR);
                }
            }
        }.runTaskLater((Plugin)this.plugin, 100L);
    }

    public void startJumpCheck() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (Light.this.hasItem(player, Material.MACE, 1232)) {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP_BOOST, -1, 4));
                        continue;
                    }
                    player.removePotionEffect(PotionEffectType.JUMP_BOOST);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public boolean hasItem(Player player, Material material, int modelData) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material || !this.hasSpecificMace(item, modelData).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean hasSpecificMace(ItemStack item, int modelData) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == modelData;
    }
}

