/*
 * Decompiled with CFR 0.152.
 */
package smp.mace.CustomMace;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import smp.mace.Util.CooldownManager;

public class Ocean
implements Listener {
    private final CooldownManager cooldown;
    private JavaPlugin plugin;

    public Ocean(CooldownManager cooldown, JavaPlugin plugin) {
        this.cooldown = cooldown;
        this.plugin = plugin;
        this.startOceanCheck();
        this.startResitanceCheck();
    }

    public ItemStack createOceanMace() {
        ItemStack oceanMace = new ItemStack(Material.MACE);
        ItemMeta meta = oceanMace.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.BLUE) + "Ocean Mace");
            meta.setCustomModelData(Integer.valueOf(1235));
            meta.setMaxStackSize(Integer.valueOf(1));
            meta.setUnbreakable(true);
            meta.setFireResistant(true);
            meta.addEnchant(Enchantment.BREACH, 5, false);
            meta.addEnchant(Enchantment.WIND_BURST, 1, false);
            oceanMace.setItemMeta(meta);
        }
        return oceanMace;
    }

    public void handleAbility(Player player) {
        if (!this.cooldown.isOnCooldown(player, "ocean_mace")) {
            this.spawnWaterAtFeet(player);
            this.cooldown.startCooldown(player, "ocean_mace", 120000L);
        } else {
            long remainingTime = this.cooldown.getCooldown(player, "ocean_mace");
            player.sendMessage("Ocean Mace is on cooldown for " + remainingTime / 1000L + " more seconds!");
        }
    }

    public void startOceanCheck() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (Ocean.this.hasItem(player, Material.MACE, 1235)) {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.DOLPHINS_GRACE, -1, 2));
                        player.addPotionEffect(new PotionEffect(PotionEffectType.CONDUIT_POWER, -1, 2));
                        continue;
                    }
                    player.removePotionEffect(PotionEffectType.DOLPHINS_GRACE);
                    player.removePotionEffect(PotionEffectType.CONDUIT_POWER);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public void startResitanceCheck() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!Ocean.this.hasItem(player, Material.MACE, 1235)) continue;
                    if (Ocean.this.isStandingOnBlock(player, Material.WATER)) {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, -1, 0));
                        continue;
                    }
                    player.removePotionEffect(PotionEffectType.RESISTANCE);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public void spawnWaterAtFeet(Player player) {
        if (!this.hasItem(player, Material.MACE, 1235)) {
            return;
        }
        World world = player.getWorld();
        if (world.getEnvironment() == World.Environment.NETHER) {
            player.sendMessage("\u00a7cThis ability does not work in the Nether!");
            return;
        }
        Block block = player.getLocation().add(0.0, 2.0, 0.0).getBlock();
        block.setType(Material.WATER);
    }

    private boolean isStandingOnBlock(Player player, Material blockType) {
        return player.getLocation().subtract(0.0, 1.0, 0.0).getBlock().getType() == blockType;
    }

    public boolean hasItem(Player player, Material material, int modelData) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material || !this.hasSpecificMace(item, modelData).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean hasSpecificMace(ItemStack item, int modelData) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == modelData;
    }
}

