/*
 * Decompiled with CFR 0.152.
 */
package smp.mace.CustomMace;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import smp.mace.Util.CooldownManager;

public class Warden
implements Listener {
    private final CooldownManager cooldown;
    private final JavaPlugin plugin;

    public Warden(CooldownManager cooldown, JavaPlugin plugin) {
        this.cooldown = cooldown;
        this.plugin = plugin;
        this.startStrengthCheck();
    }

    public ItemStack createWardenMace() {
        ItemStack wardenMace = new ItemStack(Material.MACE);
        ItemMeta meta = wardenMace.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.DARK_PURPLE) + "Warden Mace");
            meta.setCustomModelData(Integer.valueOf(1238));
            meta.setMaxStackSize(Integer.valueOf(1));
            meta.setUnbreakable(true);
            meta.setFireResistant(true);
            meta.addEnchant(Enchantment.BREACH, 5, false);
            meta.addEnchant(Enchantment.WIND_BURST, 1, false);
            wardenMace.setItemMeta(meta);
        }
        return wardenMace;
    }

    public void handleAbility(final Player player) {
        if (!this.cooldown.isOnCooldown(player, "warden_mace")) {
            final LivingEntity target = this.getNearestTarget(player, 15.0);
            if (target == null) {
                player.sendMessage("\u00a7cNo One Found!");
                return;
            }
            player.playSound(player.getLocation(), Sound.ENTITY_WARDEN_SONIC_CHARGE, 1.0f, 1.0f);
            new BukkitRunnable(){

                public void run() {
                    target.damage(50.0, (Entity)player);
                    Vector knockback = target.getLocation().toVector().subtract(player.getLocation().toVector()).normalize();
                    knockback.multiply(2).setY(0.5);
                    target.setVelocity(knockback);
                    player.getWorld().playSound(player.getLocation(), Sound.ENTITY_WARDEN_SONIC_BOOM, 2.0f, 1.0f);
                    Warden.this.showSonicBoomEffect(player.getLocation(), target.getLocation());
                    new BukkitRunnable(){

                        public void run() {
                            target.getWorld().playSound(target.getLocation(), Sound.ENTITY_WARDEN_DEATH, 1.0f, 1.0f);
                        }
                    }.runTaskLater((Plugin)Warden.this.plugin, 10L);
                }
            }.runTaskLater((Plugin)this.plugin, 20L);
            this.cooldown.startCooldown(player, "warden_mace", 120000L);
        } else {
            long remainingTime = this.cooldown.getCooldown(player, "warden_mace");
            player.sendMessage("Warden Mace is on cooldown for " + remainingTime / 1000L + " more seconds!");
        }
    }

    private LivingEntity getNearestTarget(Player player, double radius) {
        Location playerLoc = player.getLocation();
        LivingEntity nearest = null;
        double closestDistance = radius;
        for (Entity entity : player.getNearbyEntities(radius, radius, radius)) {
            double distance;
            LivingEntity target;
            if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity) instanceof Player && this.isTeammate(player, (Player)target) || !((distance = playerLoc.distanceSquared(target.getLocation())) < closestDistance)) continue;
            closestDistance = distance;
            nearest = target;
        }
        return nearest;
    }

    private boolean isTeammate(Player player, Player target) {
        return player.getScoreboard().getEntryTeam(player.getName()) != null && player.getScoreboard().getEntryTeam(player.getName()).equals((Object)target.getScoreboard().getEntryTeam(target.getName()));
    }

    private void showSonicBoomEffect(final Location start, Location end) {
        if (start.getWorld() == null || !start.getWorld().equals((Object)end.getWorld())) {
            System.out.println("Error: Start and End locations are in different worlds!");
            return;
        }
        final Vector direction = end.toVector().subtract(start.toVector()).normalize();
        final double distance = start.distance(end);
        if (distance < 0.5) {
            return;
        }
        new BukkitRunnable(this){
            final Location current;
            double i;
            {
                this.current = start.clone();
                this.i = 0.0;
            }

            public void run() {
                if (this.i >= distance) {
                    this.cancel();
                    return;
                }
                this.current.add(direction.clone().multiply(0.5));
                this.current.getWorld().spawnParticle(Particle.SONIC_BOOM, this.current, 1, 0.0, 0.0, 0.0, 0.0);
                this.current.getWorld().playSound(this.current, Sound.ENTITY_WARDEN_SONIC_BOOM, 1.0f, 1.2f);
                this.i += 0.5;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void startStrengthCheck() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (Warden.this.hasItem(player, Material.MACE, 1238)) {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, -1, 0));
                        continue;
                    }
                    PotionEffect strengthEffect = player.getPotionEffect(PotionEffectType.STRENGTH);
                    if (strengthEffect == null || strengthEffect.getDuration() != -1) continue;
                    player.removePotionEffect(PotionEffectType.STRENGTH);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
    }

    public boolean hasItem(Player player, Material material, int modelData) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material || !this.hasSpecificMace(item, modelData).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean hasSpecificMace(ItemStack item, int modelData) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == modelData;
    }
}

