/*
 * Decompiled with CFR 0.152.
 */
package smp.mace.Util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class CooldownManager {
    private final Map<UUID, Map<String, Long>> playerCooldowns = new HashMap<UUID, Map<String, Long>>();

    public long getCooldown(Player player, String itemName) {
        Map<String, Long> cooldowns = this.playerCooldowns.get(player.getUniqueId());
        if (cooldowns == null || !cooldowns.containsKey(itemName)) {
            return 0L;
        }
        long cooldownEndTime = cooldowns.get(itemName);
        return Math.max(0L, cooldownEndTime - System.currentTimeMillis());
    }

    public void startCooldown(Player player, String itemName, long cooldownTimeMillis) {
        Map cooldowns = this.playerCooldowns.computeIfAbsent(player.getUniqueId(), k -> new HashMap());
        cooldowns.put(itemName, System.currentTimeMillis() + cooldownTimeMillis);
    }

    public boolean isOnCooldown(Player player, String itemName) {
        return this.getCooldown(player, itemName) > 0L;
    }

    public void resetCooldown(Player player, String itemName) {
        Map<String, Long> cooldowns = this.playerCooldowns.get(player.getUniqueId());
        if (cooldowns != null) {
            cooldowns.remove(itemName);
        }
    }

    public void clearCooldowns(Player player) {
        this.playerCooldowns.remove(player.getUniqueId());
    }
}

