package dev.anvilcraft.lite.recipe.anvil.wrap;

import dev.anvilcraft.lib.recipe.component.ChanceItemStack;
import dev.anvilcraft.lib.recipe.component.ItemIngredientPredicate;
import dev.anvilcraft.lite.init.reicpe.ModRecipeTypes;
import dev.anvilcraft.lite.recipe.component.HasCauldronSimple;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.phys.Vec3;
import java.util.List;

/**
 * 物品压缩配方类
 * <p>
 * 该配方用于在铁砧下落时压缩物品，需要在铁砧下方放置炼药锅作为触发条件
 * </p>
 */
public class ItemCompressRecipe extends AbstractProcessRecipe<ItemCompressRecipe> {
    /**
     * 构造一个物品压缩配方
     *
     * @param itemIngredients 物品原料列表
     * @param results         结果物品列表
     */
    public ItemCompressRecipe(List<ItemIngredientPredicate> itemIngredients, List<ChanceItemStack> results) {
        super(new Property().setItemInputOffset(new Vec3(0.0, -0.375, 0.0)).setItemInputRange(new Vec3(0.75, 0.75, 0.75)).setInputItems(itemIngredients).setItemOutputOffset(new Vec3(0.0, -0.75, 0.0)).setResultItems(results).setCauldronOffset(new Vec3i(0, -1, 0)).setHasCauldron(HasCauldronSimple.empty().build()));
    }

    @Override
    public RecipeSerializer<ItemCompressRecipe> getSerializer() {
        return ModRecipeTypes.ITEM_COMPRESS_SERIALIZER.get();
    }

    @Override
    public RecipeType<ItemCompressRecipe> getType() {
        return ModRecipeTypes.ITEM_COMPRESS_TYPE.get();
    }

    /**
     * 创建一个构建器实例
     *
     * @return 构建器实例
     */
    public static Builder builder(HolderGetter<Item> getter) {
        return new Builder(getter);
    }


    /**
     * 物品压缩配方序列化器
     */
    public static class Serializer extends AbstractSerializer<ItemCompressRecipe> {
        @Override
        protected ItemCompressRecipe of(List<ItemIngredientPredicate> itemIngredients, List<ChanceItemStack> results) {
            return new ItemCompressRecipe(itemIngredients, results);
        }
    }


    /**
     * 物品压缩配方构建器
     */
    public static class Builder extends SimpleAbstractBuilder<ItemCompressRecipe, Builder> {
        protected Builder(HolderGetter<Item> getter) {
            super(getter);
        }

        @Override
        public String getType() {
            return "item_compress";
        }

        @Override
        protected ItemCompressRecipe of(List<ItemIngredientPredicate> itemIngredients, List<ChanceItemStack> results) {
            return new ItemCompressRecipe(itemIngredients, results);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}
