/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.block;

import dev.anvilcraft.lite.AnvilCraftLite;
import dev.anvilcraft.lite.block.HollowMagnetBlock;
import dev.anvilcraft.lite.init.block.ModBlockTags;
import dev.anvilcraft.lite.init.block.ModBlocks;
import dev.anvilcraft.lite.init.item.ModItems;
import dev.anvilcraft.lite.item.MagnetItem;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MagnetBlock
extends Block {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public MagnetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        this.attract(state, level, pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (level.isClientSide()) {
            return;
        }
        this.attract(state, level, pos);
        boolean bl = (Boolean)state.getValue((Property)LIT);
        if (bl != level.hasNeighborSignal(pos)) {
            if (bl) {
                level.scheduleTick(pos, (Block)this, 4);
            } else {
                level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)LIT));
            }
        }
    }

    private void attract(BlockState state, Level level, BlockPos magnetPos) {
        if (level.isClientSide()) {
            return;
        }
        if (!(state.getBlock() instanceof MagnetBlock) || ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        if (level.getBlockState(magnetPos.below()).is(BlockTags.ANVIL)) {
            return;
        }
        int distance = AnvilCraftLite.CONFIG.magnetAttractsDistance;
        BlockPos currentPos = magnetPos;
        block0: for (int i = 0; i < distance; ++i) {
            BlockState state1 = level.getBlockState(currentPos = currentPos.below());
            if (state1.is(BlockTags.ANVIL) && !state1.is(ModBlockTags.NON_MAGNETIC)) {
                level.destroyBlock(magnetPos.below(), true);
                level.setBlockAndUpdate(magnetPos.below(), state1);
                level.setBlockAndUpdate(currentPos, Blocks.AIR.defaultBlockState());
                break;
            }
            List entities = level.getEntitiesOfClass(FallingBlockEntity.class, new AABB(currentPos));
            for (FallingBlockEntity entity : entities) {
                BlockState state2 = entity.getBlockState();
                if (!state2.is(BlockTags.ANVIL) || state2.is(ModBlockTags.NON_MAGNETIC)) continue;
                level.destroyBlock(magnetPos.below(), true);
                level.setBlockAndUpdate(magnetPos.below(), state2);
                entity.remove(Entity.RemovalReason.DISCARDED);
                break block0;
            }
            BlockState blockState = level.getBlockState(currentPos);
            if (level.isEmptyBlock(currentPos) || blockState.getBlock() instanceof LiquidBlock) continue;
            return;
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && !level.hasNeighborSignal(pos)) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)LIT));
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide && state.is(ModBlocks.MAGNET_BLOCK) && player.isShiftKeyDown()) {
            player.addItem(((MagnetItem)((Object)ModItems.MAGNET_INGOT.get())).getDefaultInstance());
            level.setBlockAndUpdate(pos, ((HollowMagnetBlock)((Object)ModBlocks.HOLLOW_MAGNET_BLOCK.get())).defaultBlockState());
            level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }
}

