/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.dispense;

import dev.anvilcraft.lite.block.FerriteCoreMagnetBlock;
import dev.anvilcraft.lite.dispense.ModDispenseItemBehavior;
import dev.anvilcraft.lite.init.block.ModBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public class IronIngotBehavior
implements ModDispenseItemBehavior {
    @Override
    public ItemStack execute(BlockSource blockSource, ItemStack item) {
        ServerLevel level = blockSource.level();
        BlockState state = blockSource.state();
        BlockPos pos1 = blockSource.pos().relative((Direction)state.getValue((Property)DispenserBlock.FACING));
        BlockState blockState = level.getBlockState(pos1);
        if (blockState.is(ModBlocks.HOLLOW_MAGNET_BLOCK)) {
            level.setBlockAndUpdate(pos1, ((FerriteCoreMagnetBlock)((Object)ModBlocks.FERRITE_CORE_MAGNET_BLOCK.get())).defaultBlockState());
            item.shrink(1);
            return item;
        }
        List ironGolems = level.getEntities(EntityTypeTest.forClass(IronGolem.class), new AABB((double)pos1.getX(), (double)pos1.getY(), (double)pos1.getZ(), (double)(pos1.getX() + 1), (double)(pos1.getY() + 1), (double)(pos1.getZ() + 1)), Entity::isAlive);
        if (!ironGolems.isEmpty()) {
            ironGolems.stream().filter(ironGolem -> ironGolem.getHealth() < ironGolem.getMaxHealth()).findFirst().ifPresent(ironGolem -> {
                ironGolem.heal(Math.min(ironGolem.getHealth() + 25.0f, ironGolem.getMaxHealth()));
                item.shrink(1);
            });
        }
        return item;
    }
}

