/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.integration.jei.category.anvil;

import dev.anvilcraft.lib.recipe.component.BlockStatePredicate;
import dev.anvilcraft.lib.recipe.component.ChanceBlockState;
import dev.anvilcraft.lib.recipe.component.ChanceItemStack;
import dev.anvilcraft.lite.init.reicpe.ModRecipeTypes;
import dev.anvilcraft.lite.integration.jei.AnvilCraftJeiPlugin;
import dev.anvilcraft.lite.integration.jei.util.JeiRecipeUtil;
import dev.anvilcraft.lite.integration.jei.util.JeiRenderHelper;
import dev.anvilcraft.lite.recipe.anvil.predicate.block.HasCauldron;
import dev.anvilcraft.lite.recipe.anvil.wrap.SqueezingRecipe;
import dev.anvilcraft.lite.util.CauldronUtil;
import dev.anvilcraft.lite.util.render.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SqueezingCategory
implements IRecipeCategory<RecipeHolder<SqueezingRecipe>> {
    public static final int WIDTH = 162;
    public static final int HEIGHT = 64;
    private final IDrawable arrowDefault;
    private final IDrawable icon;
    private final ITickTimer timer;
    private final Component title;

    public SqueezingCategory(IGuiHelper helper) {
        this.arrowDefault = JeiRenderHelper.getArrowDefault(helper);
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)Items.ANVIL));
        this.title = Component.translatable((String)"gui.anvilcraft.category.squeezing");
        this.timer = helper.createTickTimer(30, 60, true);
    }

    public IRecipeType<RecipeHolder<SqueezingRecipe>> getRecipeType() {
        return AnvilCraftJeiPlugin.SQUEEZING;
    }

    public Component getTitle() {
        return this.title;
    }

    public int getWidth() {
        return 162;
    }

    public int getHeight() {
        return 64;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<SqueezingRecipe> recipeHolder, IFocusGroup focuses) {
        SqueezingRecipe recipe = (SqueezingRecipe)recipeHolder.value();
        for (BlockStatePredicate input : recipe.getInputBlocks()) {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).add(Ingredient.of(input.getBlocks().stream().map(Holder::value)));
        }
        for (ChanceItemStack output : recipe.getResultItems()) {
            builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).add(output.stack().copyWithCount(output.getMaxCount()));
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<SqueezingRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        SqueezingRecipe recipe = (SqueezingRecipe)recipeHolder.value();
        if (mouseX >= 40.0 && mouseX <= 58.0) {
            if (mouseY >= 24.0 && mouseY <= 42.0) {
                tooltip.add((FormattedText)((BlockState)recipe.getInputBlocks().getFirst().constructStatesForRender().getFirst()).getBlock().getName());
            }
            if (mouseY >= 42.0 && mouseY <= 52.0) {
                tooltip.add((FormattedText)Blocks.CAULDRON.getName());
            }
        }
        if (mouseX >= 100.0 && mouseX <= 120.0) {
            if (mouseY >= 24.0 && mouseY <= 42.0) {
                List<ChanceBlockState> result = recipe.getResultBlocks();
                if (result.isEmpty()) {
                    return;
                }
                tooltip.add((FormattedText)result.get((int)(System.currentTimeMillis() / 1000L % (long)result.size())).state().getBlock().getName());
            }
            if (mouseY >= 42.0 && mouseY <= 52.0) {
                tooltip.add((FormattedText)recipe.getHasCauldron().getTransformCauldron().getName());
            }
        }
    }

    public void draw(RecipeHolder<SqueezingRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Rect2i area = AnvilCraftJeiPlugin.AREA_WHEN_DRAW.get();
        int left = area.getX() - 9;
        int top = area.getY();
        SqueezingRecipe recipe = (SqueezingRecipe)recipeHolder.value();
        float anvilYOffset = JeiRenderHelper.getAnvilAnimationOffset(this.timer);
        ArrayList input = new ArrayList();
        for (BlockStatePredicate predicate : recipe.getInputBlocks()) {
            input.addAll(predicate.constructStatesForRender());
        }
        if (input.isEmpty()) {
            return;
        }
        BlockState renderedState = (BlockState)input.get((int)(System.currentTimeMillis() / 1000L % (long)input.size()));
        if (renderedState == null) {
            return;
        }
        RenderHelper.renderMultipleBlocks(guiGraphics, List.of(renderedState, Blocks.CAULDRON.defaultBlockState()), left + 50, top + 30, 12.0f);
        RenderHelper.renderSingleBlock(guiGraphics, Blocks.ANVIL.defaultBlockState(), left + 50, (float)(top + 12) + anvilYOffset, 12.0f);
        RenderHelper.renderSingleBlock(guiGraphics, SqueezingCategory.getCauldron(recipe), left + 110, top + 40, 12.0f);
        this.arrowDefault.draw(guiGraphics, 73, 35);
        List<ChanceBlockState> result = recipe.getResultBlocks();
        if (!result.isEmpty()) {
            renderedState = result.get((int)(System.currentTimeMillis() / 1000L % (long)result.size())).state();
            RenderHelper.renderSingleBlock(guiGraphics, renderedState, left + 110, top + 30, 12.0f);
        }
        RenderHelper.renderSingleBlock(guiGraphics, Blocks.ANVIL.defaultBlockState(), left + 110, top + 20, 12.0f);
    }

    static BlockState getCauldron(SqueezingRecipe recipe) {
        if (recipe.isProduceFluid()) {
            return Blocks.CAULDRON.defaultBlockState();
        }
        return CauldronUtil.fullState(HasCauldron.getDefaultCauldron(recipe.getHasCauldron().transform()));
    }

    public static void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(AnvilCraftJeiPlugin.SQUEEZING, JeiRecipeUtil.getRecipeHoldersFromType((RecipeType)ModRecipeTypes.SQUEEZING_TYPE.get()));
    }

    public static void registerCraftingStations(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(AnvilCraftJeiPlugin.SQUEEZING, new ItemStack[]{new ItemStack((ItemLike)Items.ANVIL)});
        registration.addCraftingStation(AnvilCraftJeiPlugin.SQUEEZING, new ItemStack[]{new ItemStack((ItemLike)Items.CAULDRON)});
    }
}

