/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.recipe.anvil.wrap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.anvilcraft.lib.recipe.component.ChanceItemStack;
import dev.anvilcraft.lib.recipe.component.ItemIngredientPredicate;
import dev.anvilcraft.lite.init.reicpe.ModRecipeTypes;
import dev.anvilcraft.lite.recipe.anvil.predicate.block.HasCauldron;
import dev.anvilcraft.lite.recipe.anvil.util.WrapUtils;
import dev.anvilcraft.lite.recipe.anvil.wrap.AbstractProcessRecipe;
import dev.anvilcraft.lite.recipe.component.HasCauldronSimple;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class BulgingRecipe
extends AbstractProcessRecipe<BulgingRecipe> {
    public BulgingRecipe(List<ItemIngredientPredicate> itemIngredients, List<ChanceItemStack> results, HasCauldronSimple hasCauldron) {
        super(new AbstractProcessRecipe.Property().setItemInputOffset(new Vec3(0.0, -0.375, 0.0)).setItemInputRange(new Vec3(0.75, 0.75, 0.75)).setInputItems(itemIngredients).setItemOutputOffset(new Vec3(0.0, -0.75, 0.0)).setResultItems(results).setCauldronOffset(new Vec3i(0, -1, 0)).setHasCauldron(hasCauldron));
    }

    @Override
    public RecipeSerializer<BulgingRecipe> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.BULGING_SERIALIZER.get();
    }

    @Override
    public RecipeType<BulgingRecipe> getType() {
        return (RecipeType)ModRecipeTypes.BULGING_TYPE.get();
    }

    public static Builder builder(HolderGetter<Item> getter) {
        return new Builder(getter);
    }

    public boolean isConsumeFluid() {
        HasCauldronSimple hasCauldron = this.getHasCauldron();
        return HasCauldron.isNotEmpty(hasCauldron.fluid()) && this.getHasCauldron().consume() > 0;
    }

    public boolean isProduceFluid() {
        HasCauldronSimple hasCauldron = this.getHasCauldron();
        return HasCauldron.isNotEmpty(hasCauldron.transform()) && this.getHasCauldron().consume() < 0;
    }

    public boolean isFromWater() {
        return this.getHasCauldron().fluid().equals((Object)BuiltInRegistries.FLUID.getKey((Object)Fluids.WATER));
    }

    public static class Builder
    extends AbstractProcessRecipe.SimpleAbstractBuilder<BulgingRecipe, Builder> {
        private final HasCauldronSimple.Builder hasCauldron = HasCauldronSimple.empty();

        protected Builder(HolderGetter<Item> getter) {
            super(getter);
        }

        public Builder cauldron(ResourceLocation fluid) {
            this.hasCauldron.fluid(fluid);
            return this;
        }

        public Builder cauldron(Block cauldron) {
            this.cauldron(WrapUtils.cauldron2Fluid(cauldron));
            return this;
        }

        public Builder transform(ResourceLocation transform) {
            this.hasCauldron.transform(transform);
            return this;
        }

        public Builder transform(Block transform) {
            this.hasCauldron.transform(WrapUtils.cauldron2Fluid(transform));
            return this;
        }

        public Builder produce(int produce) {
            if (produce <= 0) {
                return this;
            }
            this.hasCauldron.consume(-produce);
            return this;
        }

        public Builder consume(int consume) {
            if (consume <= 0) {
                return this;
            }
            this.hasCauldron.consume(consume);
            return this;
        }

        @Override
        protected BulgingRecipe of(List<ItemIngredientPredicate> itemIngredients, List<ChanceItemStack> results) {
            return new BulgingRecipe(itemIngredients, results, this.hasCauldron.build());
        }

        @Override
        public void validate(ResourceLocation pId) {
        }

        @Override
        public String getType() {
            return "bulging";
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }

    public static class Serializer
    implements RecipeSerializer<BulgingRecipe> {
        public static final MapCodec<BulgingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemIngredientPredicate.CODEC.codec().listOf().fieldOf("ingredients").forGetter(AbstractProcessRecipe::getInputItems), (App)ChanceItemStack.CODEC.listOf().fieldOf("results").forGetter(AbstractProcessRecipe::getResultItems), (App)HasCauldronSimple.CODEC.forGetter(AbstractProcessRecipe::getHasCauldron)).apply((Applicative)instance, BulgingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BulgingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemIngredientPredicate.STREAM_CODEC.apply(ByteBufCodecs.list()), AbstractProcessRecipe::getInputItems, (StreamCodec)ChanceItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), AbstractProcessRecipe::getResultItems, HasCauldronSimple.STREAM_CODEC, AbstractProcessRecipe::getHasCauldron, BulgingRecipe::new);

        public MapCodec<BulgingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BulgingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

