package dev.anvilcraft.lite.data;

import dev.anvilcraft.lite.AnvilCraftLite;
import dev.anvilcraft.lite.data.loot.ModLootTableProvider;
import dev.anvilcraft.lite.data.lang.LangHandler;
import dev.anvilcraft.lite.data.recipe.ModRecipeProvider;
import dev.anvilcraft.lite.data.tag.ModItemTagsProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

import java.util.concurrent.CompletableFuture;

@EventBusSubscriber(modid = AnvilCraftLite.MOD_ID)
public class AnvilCraftLiteDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        CompletableFuture<HolderLookup.Provider> lookupProvider = event.getLookupProvider();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(true, new ModRecipeProvider.Runner(packOutput, lookupProvider));
        generator.addProvider(true, new ModItemTagsProvider(packOutput, lookupProvider));
        generator.addProvider(true, new LangHandler(packOutput));
        generator.addProvider(true, ModLootTableProvider.create(packOutput, lookupProvider));
    }
}
