/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.block;

import dev.anvilcraft.lite.block.HollowMagnetBlock;
import dev.anvilcraft.lite.block.MagnetBlock;
import dev.anvilcraft.lite.init.block.ModBlocks;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FerriteCoreMagnetBlock
extends MagnetBlock {
    public FerriteCoreMagnetBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        int times = 0;
        for (Direction face : Direction.values()) {
            if (!serverLevel.getBlockState(blockPos.relative(face)).is((Block)ModBlocks.MAGNET_BLOCK.get())) continue;
            ++times;
        }
        if (randomSource.nextInt(7) <= times) {
            serverLevel.setBlockAndUpdate(blockPos, ((MagnetBlock)((Object)ModBlocks.MAGNET_BLOCK.get())).defaultBlockState());
        }
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide && state.is(ModBlocks.FERRITE_CORE_MAGNET_BLOCK) && player.isShiftKeyDown()) {
            player.addItem(Items.IRON_INGOT.getDefaultInstance());
            level.setBlockAndUpdate(pos, ((HollowMagnetBlock)((Object)ModBlocks.HOLLOW_MAGNET_BLOCK.get())).defaultBlockState());
            level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }
}

