/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.dispense;

import dev.anvilcraft.lite.dispense.AnvilBehavior;
import dev.anvilcraft.lite.dispense.BowlBucketBehavior;
import dev.anvilcraft.lite.dispense.ChippedAnvilBehavior;
import dev.anvilcraft.lite.dispense.DamageAnvilBehavior;
import dev.anvilcraft.lite.dispense.EmptyBottleBehavior;
import dev.anvilcraft.lite.dispense.EmptyBucketBehavior;
import dev.anvilcraft.lite.dispense.IronIngotBehavior;
import dev.anvilcraft.lite.dispense.LavaBucketBehavior;
import dev.anvilcraft.lite.dispense.MagnetIngotBehavior;
import dev.anvilcraft.lite.dispense.PowerSnowBucketBehavior;
import dev.anvilcraft.lite.dispense.WaterBottleBehavior;
import dev.anvilcraft.lite.dispense.WaterBucketBehavior;
import dev.anvilcraft.lite.init.item.ModItems;
import java.util.function.Supplier;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;

@EventBusSubscriber(modid="anvilcraft_lite")
public class DispenseBehaviors {
    @SubscribeEvent
    public static void init(FMLLoadCompleteEvent event) {
        DispenseBehaviors.register((ItemLike)Items.GLASS_BOTTLE, EmptyBottleBehavior::new);
        DispenseBehaviors.register((ItemLike)Items.POTION, WaterBottleBehavior::new);
        DispenseBehaviors.register((ItemLike)Items.BUCKET, EmptyBucketBehavior::new);
        DispenseBehaviors.register((ItemLike)Items.WATER_BUCKET, WaterBucketBehavior::new);
        DispenseBehaviors.register((ItemLike)Items.LAVA_BUCKET, LavaBucketBehavior::new);
        DispenseBehaviors.register((ItemLike)Items.POWDER_SNOW_BUCKET, PowerSnowBucketBehavior::new);
        DispenseBehaviors.register((ItemLike)Items.BOWL, BowlBucketBehavior::new);
        DispenseBehaviors.register((ItemLike)Items.IRON_INGOT, IronIngotBehavior::new);
        DispenseBehaviors.register(ModItems.MAGNET_INGOT, MagnetIngotBehavior::new);
        DispenseBehaviors.register((ItemLike)Items.ANVIL, AnvilBehavior::new);
        DispenseBehaviors.register((ItemLike)Items.CHIPPED_ANVIL, ChippedAnvilBehavior::new);
        DispenseBehaviors.register((ItemLike)Items.DAMAGED_ANVIL, DamageAnvilBehavior::new);
    }

    public static void register(ItemLike item, Supplier<DispenseItemBehavior> factory) {
        DispenserBlock.DISPENSER_REGISTRY.put(item.asItem(), factory.get());
    }
}

