/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.recipe.anvil.predicate.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.anvilcraft.lib.recipe.cache.BlockCache;
import dev.anvilcraft.lib.recipe.predicate.IRecipePredicate;
import dev.anvilcraft.lib.recipe.util.InWorldRecipeContext;
import dev.anvilcraft.lib.util.CodecUtil;
import dev.anvilcraft.lite.init.reicpe.ModRecipePredicateTypes;
import dev.anvilcraft.lite.recipe.anvil.util.WrapUtils;
import dev.anvilcraft.lite.util.CauldronUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public record HasCauldron(Vec3 offset, ResourceLocation fluid, int consume, ResourceLocation transform) implements IRecipePredicate<HasCauldron>
{
    public static final ResourceLocation EMPTY = ResourceLocation.withDefaultNamespace((String)"empty");
    public static final ResourceLocation NULL = ResourceLocation.withDefaultNamespace((String)"null");

    public static HasCauldron empty(Vec3 offset) {
        return new HasCauldron(offset, EMPTY, 0, NULL);
    }

    public boolean test(InWorldRecipeContext context) {
        Vec3 pos = context.getPos().add(this.offset());
        BlockPos blockPos = BlockPos.containing((Position)pos);
        BlockCache cache = (BlockCache)context.computeIfAbsent(BlockCache.BLOCK_CACHE);
        BlockState curState = cache.getBlockState(blockPos);
        if (!curState.is(BlockTags.CAULDRONS)) {
            return false;
        }
        Block fluidCauldron = this.getFluidCauldron();
        if (curState.is(fluidCauldron)) {
            return true;
        }
        if (HasCauldron.isNotEmpty(this.fluid())) {
            return false;
        }
        if (!HasCauldron.isNotEmpty(this.transform())) {
            return false;
        }
        Block targetCauldron = this.getTransformCauldron();
        BlockState targetState = targetCauldron.defaultBlockState();
        Optional<Tuple<IntegerProperty, Integer>> optionalTarget = HasCauldron.getFluidLevel(targetState);
        int max = optionalTarget.map(tuple -> ((IntegerProperty)tuple.getA()).max).orElse(0);
        Optional<Tuple<IntegerProperty, Integer>> optionalCur = HasCauldron.getFluidLevel(curState);
        int cur = optionalCur.map(Tuple::getB).orElse(0);
        return cur < max;
    }

    public void accept(InWorldRecipeContext context) {
        if (this.fluid.equals((Object)EMPTY) && !HasCauldron.isNotEmpty(this.transform())) {
            return;
        }
        BlockPos blockPos = BlockPos.containing((Position)context.getPos().add(this.offset()));
        BlockCache cache = (BlockCache)context.computeIfAbsent(BlockCache.BLOCK_CACHE);
        BlockState curState = cache.getBlockState(blockPos);
        Block emptyCauldron = Blocks.CAULDRON;
        Block fluidCauldron = this.getFluidCauldron();
        Block transformCauldron = this.getTransformCauldron();
        Block targetCauldron = HasCauldron.isNotEmpty(this.transform()) ? transformCauldron : fluidCauldron;
        BlockState targetState = targetCauldron.defaultBlockState();
        Optional<Tuple<IntegerProperty, Integer>> optionalCur = HasCauldron.getFluidLevel(curState);
        Optional<Tuple<IntegerProperty, Integer>> optionalTarget = HasCauldron.getFluidLevel(targetState);
        int cur = !curState.is(emptyCauldron) && (curState.is(fluidCauldron) || curState.is(transformCauldron)) ? HasCauldron.layer2Mb(optionalCur.map(Tuple::getA).orElse(IntegerProperty.create((String)"level", (int)0, (int)1)), optionalCur.map(Tuple::getB).orElse(1)) : 0;
        int target = cur - this.consume();
        if (target <= 0) {
            targetState = emptyCauldron.defaultBlockState();
        } else {
            IntegerProperty property = optionalTarget.map(Tuple::getA).orElse(IntegerProperty.create((String)"level", (int)0, (int)1));
            Integer max = optionalTarget.map(tuple -> ((IntegerProperty)tuple.getA()).max).orElse(1);
            target = HasCauldron.mb2Layer(property, Math.clamp((long)target, 1, HasCauldron.layer2Mb(property, max)));
            if (optionalTarget.isPresent()) {
                targetState = (BlockState)targetState.setValue((Property)property, (Comparable)Integer.valueOf(target));
            }
        }
        cache.setBlock(blockPos, targetState);
        context.putAcceptor(BlockCache.BLOCK_CACHE.location(), BlockCache.DEFAULT_ACCEPTOR);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Block getDefaultCauldron(ResourceLocation fluid) {
        if (fluid.equals((Object)EMPTY) || fluid.equals((Object)NULL)) {
            return Blocks.CAULDRON;
        }
        String namespace = fluid.getNamespace();
        String path = fluid.getPath();
        ResourceLocation cauldron = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"%s_cauldron".formatted(path));
        Holder.Reference reference = BuiltInRegistries.BLOCK.get(cauldron).orElse(null);
        Block block = Blocks.WATER_CAULDRON;
        if (reference != null) {
            block = (Block)reference.value();
        }
        return block;
    }

    public static boolean isNotEmpty(ResourceLocation fluid) {
        return !fluid.equals((Object)NULL) && !fluid.equals((Object)EMPTY);
    }

    public static Optional<Tuple<IntegerProperty, Integer>> getFluidLevel(BlockState state) {
        IntegerProperty property = CauldronUtil.LEVEL_4;
        Optional value = state.getOptionalValue((Property)property);
        if (value.isEmpty()) {
            property = CauldronUtil.LEVEL_3;
            value = state.getOptionalValue((Property)property);
        }
        return value.isPresent() ? Optional.of(new Tuple((Object)property, (Object)((Integer)value.get()))) : Optional.empty();
    }

    public static int mb2Layer(IntegerProperty property, int mb) {
        int max = property.max;
        double mbPreLayer = 1000.0 / (double)max;
        return (int)Math.round((double)mb / mbPreLayer);
    }

    public static int layer2Mb(IntegerProperty property, int layer) {
        int max = property.max;
        double mbPreLayer = 1000.0 / (double)max;
        return (int)Math.round((double)layer * mbPreLayer);
    }

    public Block getFluidCauldron() {
        return HasCauldron.getDefaultCauldron(this.fluid);
    }

    public Block getTransformCauldron() {
        return HasCauldron.getDefaultCauldron(this.transform);
    }

    public Type getType() {
        return (Type)ModRecipePredicateTypes.HAS_CAULDRON.get();
    }

    public static class Builder {
        private Vec3 offset = Vec3.ZERO;
        private ResourceLocation fluid = EMPTY;
        private int consume = 0;
        private ResourceLocation transform = NULL;

        public Builder offset(Vec3 offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(double x, double y, double z) {
            return this.offset(new Vec3(x, y, z));
        }

        public Builder below(double below) {
            return this.offset(Vec3.ZERO.subtract(0.0, below, 0.0));
        }

        public Builder below() {
            return this.below(1.0);
        }

        public Builder above(double above) {
            return this.offset(Vec3.ZERO.add(0.0, above, 0.0));
        }

        public Builder above() {
            return this.above(1.0);
        }

        public Builder empty() {
            this.fluid = EMPTY;
            return this;
        }

        public Builder fluid(ResourceLocation fluid) {
            this.fluid = fluid;
            return this;
        }

        public Builder cauldron(Block cauldron) {
            this.fluid = WrapUtils.cauldron2Fluid(cauldron);
            return this;
        }

        public Builder transform(ResourceLocation transform) {
            this.transform = transform;
            return this;
        }

        public Builder consume(int consume) {
            this.consume = consume;
            return this;
        }

        public Builder produce(int produce) {
            this.consume = -produce;
            return this;
        }

        public HasCauldron build() {
            return new HasCauldron(this.offset, this.fluid, this.consume, this.transform);
        }
    }

    public static class Type
    implements IRecipePredicate.Type<HasCauldron> {
        public final MapCodec<HasCauldron> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Vec3.CODEC.fieldOf("offset").forGetter(HasCauldron::offset), (App)ResourceLocation.CODEC.optionalFieldOf("fluid", (Object)EMPTY).forGetter(HasCauldron::fluid), (App)Codec.INT.optionalFieldOf("consume", (Object)0).forGetter(HasCauldron::consume), (App)ResourceLocation.CODEC.optionalFieldOf("transform", (Object)NULL).forGetter(HasCauldron::transform)).apply((Applicative)instance, HasCauldron::new));
        public final StreamCodec<RegistryFriendlyByteBuf, HasCauldron> mapCodec = StreamCodec.composite((StreamCodec)CodecUtil.VEC3_STREAM_CODEC, HasCauldron::offset, (StreamCodec)ResourceLocation.STREAM_CODEC, HasCauldron::fluid, (StreamCodec)ByteBufCodecs.INT, HasCauldron::consume, (StreamCodec)ResourceLocation.STREAM_CODEC, HasCauldron::transform, HasCauldron::new);

        public MapCodec<HasCauldron> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, HasCauldron> streamCodec() {
            return this.mapCodec;
        }
    }
}

