/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.recipe.anvil.wrap;

import dev.anvilcraft.lib.recipe.InWorldRecipe;
import dev.anvilcraft.lite.AnvilCraftLite;
import dev.anvilcraft.lite.init.item.ModItemTags;
import dev.anvilcraft.lite.mixin.accessor.ShapedRecipeAccessor;
import dev.anvilcraft.lite.mixin.accessor.ShapelessRecipeAccessor;
import dev.anvilcraft.lite.mixin.accessor.SingleItemRecipeAccessor;
import dev.anvilcraft.lite.recipe.anvil.wrap.CookingRecipe;
import dev.anvilcraft.lite.recipe.anvil.wrap.ItemCompressRecipe;
import dev.anvilcraft.lite.recipe.anvil.wrap.SuperHeatingRecipe;
import dev.anvilcraft.lite.recipe.anvil.wrap.UnpackRecipe;
import dev.anvilcraft.lite.util.RecipeUtil;
import dev.anvilcraft.lite.util.Util;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.TriState;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.neoforged.neoforge.common.Tags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaRecipesWrap {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VanillaRecipesWrap.class);
    private static Set<Item> cooked = new HashSet<Item>();
    private static List<SmeltingRecipe> smeltingRecipes;
    public static List<RecipeHolder<InWorldRecipe>> recipes;

    public static List<RecipeHolder<InWorldRecipe>> init(HolderGetter.Provider registries, Collection<RecipeHolder<?>> recipes) {
        cooked = Collections.synchronizedSet(new HashSet());
        smeltingRecipes = Collections.synchronizedList(new ArrayList());
        VanillaRecipesWrap.recipes = new ArrayList<RecipeHolder<InWorldRecipe>>();
        HolderGetter items = registries.lookupOrThrow(Registries.ITEM);
        for (RecipeHolder<?> recipeHolder : recipes) {
            VanillaRecipesWrap.wrap((HolderGetter<Item>)items, recipeHolder).ifPresent(VanillaRecipesWrap.recipes::add);
        }
        smeltingRecipes.forEach(recipe -> VanillaRecipesWrap.wrap((HolderGetter<Item>)items, recipe));
        return VanillaRecipesWrap.recipes;
    }

    public static Optional<RecipeHolder<InWorldRecipe>> wrap(HolderGetter<Item> items, RecipeHolder<?> holder) {
        Recipe recipeRaw;
        Recipe recipe = recipeRaw = holder.value();
        Objects.requireNonNull(recipe);
        Recipe recipe2 = recipe;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedRecipe.class, ShapelessRecipe.class, BlastingRecipe.class, SmokingRecipe.class, CampfireCookingRecipe.class, SmeltingRecipe.class}, (Object)recipe2, n)) {
            case 0 -> {
                ShapedRecipe recipe = (ShapedRecipe)recipe2;
                ShapedRecipeAccessor accessor = (ShapedRecipeAccessor)Util.cast(recipe);
                ShapedRecipePattern pattern = recipe.pattern;
                if (pattern == null) {
                    yield Optional.empty();
                }
                if (pattern.height() != pattern.width() || pattern.height() == 1) {
                    yield Optional.empty();
                }
                ItemStack result = accessor.getResult();
                if (result == null) {
                    yield Optional.empty();
                }
                if (!(result = result.copy()).is(ModItemTags.COMPRESS_ITEM)) {
                    yield Optional.empty();
                }
                List ingredients = pattern.ingredients();
                Ingredient first = null;
                int size = pattern.height() * pattern.width();
                for (int i = 0; i < size; ++i) {
                    Optional ingredientOp = (Optional)ingredients.get(i);
                    if (ingredientOp.isEmpty()) {
                        yield Optional.empty();
                    }
                    if (first == null) {
                        first = (Ingredient)ingredientOp.get();
                        continue;
                    }
                    if (first.equals(ingredientOp.get())) continue;
                    yield Optional.empty();
                }
                if (first == null) {
                    yield Optional.empty();
                }
                yield Optional.of(new RecipeHolder(VanillaRecipesWrap.key("compress_warp_%s_2_%s".formatted(RecipeUtil.getName(first), BuiltInRegistries.ITEM.getKey((Object)result.getItem()).getPath())), ((ItemCompressRecipe.Builder)((ItemCompressRecipe.Builder)ItemCompressRecipe.builder(items).result(result)).requires(RecipeUtil.wrapIngredient(items, first).withCount(pattern.height() * pattern.width()).build())).buildRecipe()));
            }
            case 1 -> {
                ShapelessRecipe recipe = (ShapelessRecipe)recipe2;
                ShapelessRecipeAccessor accessor = (ShapelessRecipeAccessor)Util.cast(recipe);
                List<Ingredient> ingredients = accessor.getIngredients();
                if (ingredients.isEmpty()) {
                    yield Optional.empty();
                }
                Ingredient first = ingredients.getFirst();
                ItemStack result = accessor.getResult();
                if (result == null) {
                    yield Optional.empty();
                }
                result = result.copy();
                if (ingredients.size() == 1) {
                    yield Optional.of(new RecipeHolder(VanillaRecipesWrap.key("unpack_warp_%s_2_%s".formatted(RecipeUtil.getName(first), BuiltInRegistries.ITEM.getKey((Object)result.getItem()).getPath())), ((UnpackRecipe.Builder)((UnpackRecipe.Builder)UnpackRecipe.builder(items).result(result)).requires(RecipeUtil.wrapIngredient(items, first).build())).buildRecipe()));
                }
                if (ingredients.size() != 4 && ingredients.size() != 9) {
                    yield Optional.empty();
                }
                if (!result.is(Tags.Items.STORAGE_BLOCKS) && !result.is(ModItemTags.COMPRESS_ITEM)) {
                    yield Optional.empty();
                }
                for (Ingredient ingredient : ingredients) {
                    if (ingredient.equals((Object)first)) continue;
                    yield Optional.empty();
                }
                yield Optional.of(new RecipeHolder(VanillaRecipesWrap.key("compress_warp_%s_2_%s".formatted(RecipeUtil.getName(first), BuiltInRegistries.ITEM.getKey((Object)result.getItem()).getPath())), ((ItemCompressRecipe.Builder)((ItemCompressRecipe.Builder)ItemCompressRecipe.builder(items).result(result)).requires(RecipeUtil.wrapIngredient(items, first).withCount(ingredients.size()).build())).buildRecipe()));
            }
            case 2 -> {
                BlastingRecipe recipe = (BlastingRecipe)recipe2;
                SingleItemRecipeAccessor accessor = (SingleItemRecipeAccessor)Util.cast(recipe);
                ItemStack result = accessor.getResult();
                if (result == null) {
                    yield Optional.empty();
                }
                result = result.copy();
                Ingredient input = accessor.getInput();
                boolean boost = RecipeUtil.testIngredient(input, itemHolder -> itemHolder.is(ModItemTags.SUPER_HEATING_BOOST_PRODUCTION)) == TriState.TRUE;
                cooked.add(result.getItem());
                yield Optional.of(new RecipeHolder(VanillaRecipesWrap.key("super_heating_warp_%s_2_%s".formatted(RecipeUtil.getName(input), BuiltInRegistries.ITEM.getKey((Object)result.getItem()).getPath())), ((SuperHeatingRecipe.Builder)((SuperHeatingRecipe.Builder)SuperHeatingRecipe.builder(items).result(result.copyWithCount(boost ? 2 : 1))).requires(RecipeUtil.wrapIngredient(items, input).build())).buildRecipe()));
            }
            case 3 -> {
                SmokingRecipe recipe = (SmokingRecipe)recipe2;
                SingleItemRecipeAccessor accessor = (SingleItemRecipeAccessor)Util.cast(recipe);
                ItemStack result = accessor.getResult();
                if (result == null) {
                    yield Optional.empty();
                }
                result = result.copy();
                Ingredient input = accessor.getInput();
                cooked.add(result.getItem());
                yield Optional.of(new RecipeHolder(VanillaRecipesWrap.key("smoking_warp_%s_2_%s".formatted(RecipeUtil.getName(input), BuiltInRegistries.ITEM.getKey((Object)result.getItem()).getPath())), ((CookingRecipe.Builder)((CookingRecipe.Builder)CookingRecipe.builder(items).result(result)).requires(RecipeUtil.wrapIngredient(items, input).build())).buildRecipe()));
            }
            case 4 -> {
                CampfireCookingRecipe recipe = (CampfireCookingRecipe)recipe2;
                SingleItemRecipeAccessor accessor = (SingleItemRecipeAccessor)Util.cast(recipe);
                ItemStack result = accessor.getResult();
                if (result == null) {
                    yield Optional.empty();
                }
                result = result.copy();
                Ingredient input = accessor.getInput();
                cooked.add(result.getItem());
                yield Optional.of(new RecipeHolder(VanillaRecipesWrap.key("cooking_warp_%s_2_%s".formatted(RecipeUtil.getName(input), BuiltInRegistries.ITEM.getKey((Object)result.getItem()).getPath())), ((CookingRecipe.Builder)((CookingRecipe.Builder)CookingRecipe.builder(items).result(result)).requires(RecipeUtil.wrapIngredient(items, input).build())).buildRecipe()));
            }
            case 5 -> {
                SmeltingRecipe recipe = (SmeltingRecipe)recipe2;
                smeltingRecipes.add(recipe);
                yield Optional.empty();
            }
            default -> Optional.empty();
        };
    }

    public static void wrap(HolderGetter<Item> items, SmeltingRecipe recipe) {
        SingleItemRecipeAccessor accessor = (SingleItemRecipeAccessor)Util.cast(recipe);
        ItemStack result = accessor.getResult();
        if (result == null) {
            return;
        }
        if (cooked.contains((result = result.copy()).getItem())) {
            return;
        }
        Ingredient input = accessor.getInput();
        recipes.add((RecipeHolder<InWorldRecipe>)new RecipeHolder(VanillaRecipesWrap.key("heating_warp_%s_2_%s".formatted(RecipeUtil.getName(input), BuiltInRegistries.ITEM.getKey((Object)result.getItem()).getPath())), ((SuperHeatingRecipe.Builder)((SuperHeatingRecipe.Builder)SuperHeatingRecipe.builder(items).result(result)).requires(RecipeUtil.wrapIngredient(items, input).build())).buildRecipe()));
    }

    public static ResourceKey<Recipe<?>> key(String path) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)AnvilCraftLite.of(path));
    }
}

