package dev.anvilcraft.lite.dispense;

import net.minecraft.core.BlockPos;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;

public class EmptyBottleBehavior implements ModDispenseItemBehavior {
    @Override
    public ItemStack execute(BlockSource blockSource, ItemStack item) {
        ServerLevel level = blockSource.level();
        BlockState state = blockSource.state();
        BlockPos pos1 = blockSource.pos().relative(state.getValue(DispenserBlock.FACING));
        BlockState blockState = level.getBlockState(pos1);
        if (blockState.is(Blocks.WATER_CAULDRON)) {
            LayeredCauldronBlock.lowerFillLevel(blockState, level, pos1);
            return ModDispenseItemBehavior.consumeWithRemainder(
                blockSource,
                item,
                PotionContents.createItemStack(Items.POTION.getDefaultInstance().getItem(), Potions.WATER)
            );
        }
        return item;
    }
}
