/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.dispense;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public interface ModDispenseItemBehavior
extends DispenseItemBehavior {
    public static final DefaultDispenseItemBehavior DEFAULT_DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior();

    public static void playDefaultSound(BlockSource blockSource) {
        blockSource.level().levelEvent(1000, blockSource.pos(), 0);
    }

    public static void playDefaultAnimation(BlockSource blockSource, Direction direction) {
        blockSource.level().levelEvent(2000, blockSource.pos(), direction.get3DDataValue());
    }

    default public ItemStack dispense(BlockSource blockSource, ItemStack item) {
        this.playSound(blockSource);
        this.playAnimation(blockSource, (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
        ItemStack stack = this.execute(blockSource, item.copy());
        if (!ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)stack) || stack.getCount() != item.getCount()) {
            return stack;
        }
        return DEFAULT_DISPENSE_ITEM_BEHAVIOR.dispense(blockSource, item);
    }

    public ItemStack execute(BlockSource var1, ItemStack var2);

    default public void playSound(BlockSource blockSource) {
        ModDispenseItemBehavior.playDefaultSound(blockSource);
    }

    default public void playAnimation(BlockSource blockSource, Direction direction) {
        ModDispenseItemBehavior.playDefaultAnimation(blockSource, direction);
    }

    public static ItemStack consumeWithRemainder(BlockSource blockSource, ItemStack stack, ItemStack remainder) {
        stack.shrink(1);
        if (stack.isEmpty()) {
            return remainder;
        }
        ModDispenseItemBehavior.addToInventoryOrDispense(blockSource, remainder);
        return stack;
    }

    public static void addToInventoryOrDispense(BlockSource blockSource, ItemStack remainder) {
        ItemStack itemstack = blockSource.blockEntity().insertItem(remainder);
        if (!itemstack.isEmpty()) {
            Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
            ModDispenseItemBehavior.spawnItem((Level)blockSource.level(), itemstack, 6, direction, DispenserBlock.getDispensePosition((BlockSource)blockSource));
            ModDispenseItemBehavior.playDefaultSound(blockSource);
            ModDispenseItemBehavior.playDefaultAnimation(blockSource, direction);
        }
    }

    public static void spawnItem(Level level, ItemStack stack, int speed, Direction facing, Position position) {
        double d0 = position.x();
        double d1 = position.y();
        double d2 = position.z();
        d1 = facing.getAxis() == Direction.Axis.Y ? (d1 -= 0.125) : (d1 -= 0.15625);
        ItemEntity itementity = new ItemEntity(level, d0, d1, d2, stack);
        double d3 = level.random.nextDouble() * 0.1 + 0.2;
        itementity.setDeltaMovement(level.random.triangle((double)facing.getStepX() * d3, 0.0172275 * (double)speed), level.random.triangle(0.2, 0.0172275 * (double)speed), level.random.triangle((double)facing.getStepZ() * d3, 0.0172275 * (double)speed));
        level.addFreshEntity((Entity)itementity);
    }
}

