/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.integration.jei.util;

import dev.anvilcraft.lite.integration.jei.util.TextureConstants;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;

public class JeiRenderHelper {
    public static float getAnvilAnimationOffset(ITickTimer timer) {
        return timer.getValue() < 30 ? JeiRenderHelper.getAnvilAnimationOffset(timer.getValue()) : 8.0f;
    }

    public static float getAnvilAnimationOffset(float time) {
        return (float)Math.sin((double)time / 30.0 * 2.0 * Math.PI + 1.5707963267948966) * 8.0f;
    }

    public static IDrawable getArrowDefault(IGuiHelper helper) {
        return helper.drawableBuilder(TextureConstants.ARROW_DEFAULT, 0, 0, 16, 10).setTextureSize(16, 10).build();
    }

    public static IDrawable getArrowInput(IGuiHelper helper) {
        return helper.drawableBuilder(TextureConstants.ARROW_INPUT, 0, 0, 16, 8).setTextureSize(16, 8).build();
    }

    public static IDrawable getArrowOutput(IGuiHelper helper) {
        return helper.drawableBuilder(TextureConstants.ARROW_OUTPUT, 0, 0, 16, 10).setTextureSize(16, 10).build();
    }

    public static IDrawable getArrowOutputFromBelow(IGuiHelper helper) {
        return helper.drawableBuilder(TextureConstants.ARROW_OUTPUT_FROM_BELOW, 0, 0, 14, 18).setTextureSize(14, 18).build();
    }

    public static IDrawable getArrowBlockConversion(IGuiHelper helper) {
        return helper.drawableBuilder(TextureConstants.ARROW_BLOCK_CONVERSION, 0, 0, 14, 22).setTextureSize(14, 22).build();
    }

    public static IDrawable getSlotDefault(IGuiHelper helper) {
        return helper.drawableBuilder(TextureConstants.SLOT_DEFAULT, 0, 0, 18, 18).setTextureSize(18, 18).build();
    }

    public static IDrawable getSlotChoice(IGuiHelper helper) {
        return helper.drawableBuilder(TextureConstants.SLOT_CHOICE, 0, 0, 18, 18).setTextureSize(18, 18).build();
    }

    public static IDrawable getSlotProbability(IGuiHelper helper) {
        return helper.drawableBuilder(TextureConstants.SLOT_PROBABILITY, 0, 0, 18, 18).setTextureSize(18, 18).build();
    }
}

