/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.integration.jei.util;

import dev.anvilcraft.lib.recipe.component.ChanceItemStack;
import dev.anvilcraft.lib.recipe.component.ItemIngredientPredicate;
import dev.anvilcraft.lite.integration.jei.util.JeiRecipeUtil;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;

public class JeiSlotUtil {
    public static void drawInputSlots(GuiGraphics guiGraphics, IDrawable slot, int inputSize) {
        if (inputSize == 0) {
            return;
        }
        if (inputSize == 1) {
            slot.draw(guiGraphics, 20, 23);
        } else if (inputSize <= 4) {
            int startX = 10;
            int startY = 14;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    slot.draw(guiGraphics, startX + j * 19, startY + i * 19);
                }
            }
        } else if (inputSize <= 6) {
            int startX = 1;
            int startY = 14;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    slot.draw(guiGraphics, startX + j * 19, startY + i * 19);
                }
            }
        } else {
            int startX = 1;
            int startY = 5;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    slot.draw(guiGraphics, startX + j * 19, startY + i * 19);
                }
            }
        }
    }

    public static void drawOutputSlots(GuiGraphics guiGraphics, IDrawable slot, int outputSize) {
        if (outputSize == 0) {
            return;
        }
        if (outputSize == 1) {
            slot.draw(guiGraphics, 124, 23);
        } else if (outputSize <= 4) {
            int startX = 116;
            int startY = 14;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    slot.draw(guiGraphics, startX + j * 19, startY + i * 19);
                }
            }
        } else if (outputSize <= 6) {
            int startX = 107;
            int startY = 14;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    slot.draw(guiGraphics, startX + j * 19, startY + i * 19);
                }
            }
        } else {
            int startX = 107;
            int startY = 5;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    slot.draw(guiGraphics, startX + j * 19, startY + i * 19);
                }
            }
        }
    }

    public static void addSlotWithCount(IRecipeLayoutBuilder builder, int slotX, int slotY, ItemIngredientPredicate entry) {
        IRecipeSlotBuilder slot = builder.addInputSlot(slotX, slotY);
        slot.addItemStacks(List.of(entry.getItems()));
    }

    public static void addInputSlots(IRecipeLayoutBuilder builder, List<ItemIngredientPredicate> mergedIngredients) {
        int inputSize = mergedIngredients.size();
        if (inputSize == 0) {
            return;
        }
        if (inputSize == 1) {
            ItemIngredientPredicate ingredient = mergedIngredients.getFirst();
            IRecipeSlotBuilder slot = builder.addInputSlot(21, 24);
            slot.addItemStacks(List.of(ingredient.getItems()));
        } else if (inputSize <= 4) {
            int startX = 11;
            int startY = 15;
            for (int index = 0; index < inputSize; ++index) {
                int row = index / 2;
                int col = index % 2;
                JeiSlotUtil.addSlotWithCount(builder, startX + 19 * col, startY + 19 * row, mergedIngredients.get(index));
            }
        } else if (inputSize <= 6) {
            int startX = 2;
            int startY = 15;
            for (int index = 0; index < inputSize; ++index) {
                int row = index / 3;
                int col = index % 3;
                JeiSlotUtil.addSlotWithCount(builder, startX + 19 * col, startY + 19 * row, mergedIngredients.get(index));
            }
        } else {
            int startX = 1;
            int startY = 6;
            for (int index = 0; index < inputSize && index <= 9; ++index) {
                int row = index / 3;
                int col = index % 3;
                JeiSlotUtil.addSlotWithCount(builder, startX + 19 * col, startY + 19 * row, mergedIngredients.get(index));
            }
        }
    }

    public static void addOutputSlots(IRecipeLayoutBuilder builder, List<ChanceItemStack> results) {
        int outputSize = results.size();
        if (outputSize == 0) {
            return;
        }
        if (outputSize == 1) {
            ChanceItemStack stack = results.getFirst();
            ItemStack itemStack = stack.stack().copy();
            if (stack.count() instanceof ConstantValue) {
                itemStack.setCount(stack.getMaxCount());
            }
            IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addOutputSlot(125, 24).add(itemStack);
            JeiRecipeUtil.addTooltips(slot, stack.getMaxCount(), stack.count());
        } else if (outputSize <= 4) {
            int startX = 117;
            int startY = 15;
            for (int index = 0; index < outputSize; ++index) {
                int row = index / 2;
                int col = index % 2;
                ChanceItemStack stack = results.get(index);
                ItemStack itemStack = stack.stack().copy();
                if (stack.count() instanceof ConstantValue) {
                    itemStack.setCount(stack.getMaxCount());
                }
                IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addOutputSlot(startX + 19 * col, startY + 19 * row).add(itemStack);
                JeiRecipeUtil.addTooltips(slot, stack.getMaxCount(), stack.count());
            }
        } else if (outputSize <= 6) {
            int startX = 108;
            int startY = 15;
            for (int index = 0; index < outputSize; ++index) {
                int row = index / 2;
                int col = index % 3;
                ChanceItemStack stack = results.get(index);
                ItemStack itemStack = stack.stack().copy();
                if (stack.count() instanceof ConstantValue) {
                    itemStack.setCount(stack.getMaxCount());
                }
                IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addOutputSlot(startX + 19 * col, startY + 19 * row).add(itemStack);
                JeiRecipeUtil.addTooltips(slot, stack.getMaxCount(), stack.count());
            }
        } else {
            int startX = 108;
            int startY = 6;
            for (int index = 0; index < outputSize && index <= 9; ++index) {
                int row = index / 3;
                int col = index % 3;
                ChanceItemStack stack = results.get(index);
                ItemStack itemStack = stack.stack().copy();
                if (stack.count() instanceof ConstantValue) {
                    itemStack.setCount(stack.getMaxCount());
                }
                IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addOutputSlot(startX + 19 * col, startY + 19 * row).add(itemStack);
                JeiRecipeUtil.addTooltips(slot, stack.getMaxCount(), stack.count());
            }
        }
    }
}

