/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.item;

import dev.anvilcraft.lite.init.item.ModComponents;
import dev.anvilcraft.lite.item.ResinBlockItem;
import dev.anvilcraft.lite.item.property.component.SavedEntity;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class HasMobBlockItem
extends BlockItem {
    public HasMobBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        if (!HasMobBlockItem.hasMob(stack)) {
            return;
        }
        Optional.ofNullable(context.level()).map(level -> HasMobBlockItem.getMobFromItem(level, stack)).ifPresent(entity -> tooltipAdder.accept((Component)Component.literal((String)"- ").append(entity.getDisplayName()).withStyle(ChatFormatting.DARK_GRAY)));
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
    }

    public static boolean hasMob(ItemStack stack) {
        return stack.has(ModComponents.SAVED_ENTITY);
    }

    @Nullable
    public static Entity getMobFromItem(Level level, ItemStack stack) {
        if (!HasMobBlockItem.hasMob(stack)) {
            return null;
        }
        SavedEntity savedEntity = (SavedEntity)stack.get(ModComponents.SAVED_ENTITY);
        if (savedEntity == null) {
            return null;
        }
        return savedEntity.toEntity(level);
    }

    public static void saveMobInItem(Level level, Mob entity, Player player, ItemStack stack) {
        MobEffectInstance instance;
        if (level.isClientSide()) {
            Item item = stack.getItem();
            if (item instanceof ResinBlockItem) {
                ResinBlockItem item1 = (ResinBlockItem)item;
                BlockPos blockPos = entity.getOnPos();
                BlockState blockState = item1.getBlock().defaultBlockState();
                SoundType soundType = blockState.getSoundType();
                level.playSound((Entity)player, blockPos, item1.getPlaceSound(blockState), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            }
            return;
        }
        SavedEntity savedEntity = SavedEntity.fromMob(entity);
        if (entity.getType().getCategory() == MobCategory.MONSTER && (instance = entity.getEffect(MobEffects.WEAKNESS)) == null && !player.getAbilities().instabuild) {
            return;
        }
        stack = stack.split(1);
        stack.set(ModComponents.SAVED_ENTITY, (Object)savedEntity);
        player.getInventory().placeItemBackInInventory(stack);
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            villager.releasePoi(MemoryModuleType.HOME);
            villager.releasePoi(MemoryModuleType.JOB_SITE);
            villager.releasePoi(MemoryModuleType.POTENTIAL_JOB_SITE);
            villager.releasePoi(MemoryModuleType.MEETING_POINT);
        }
        entity.remove(Entity.RemovalReason.DISCARDED);
    }
}

