/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.recipe.anvil.wrap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.anvilcraft.lib.recipe.component.BlockStatePredicate;
import dev.anvilcraft.lib.recipe.component.ChanceBlockState;
import dev.anvilcraft.lite.init.reicpe.ModRecipeTypes;
import dev.anvilcraft.lite.recipe.anvil.builder.AbstractRecipeBuilder;
import dev.anvilcraft.lite.recipe.anvil.util.WrapUtils;
import dev.anvilcraft.lite.recipe.anvil.wrap.AbstractProcessRecipe;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;

public class BlockCrushRecipe
extends AbstractProcessRecipe<BlockCrushRecipe> {
    public BlockCrushRecipe(BlockStatePredicate input, ChanceBlockState result) {
        super(new AbstractProcessRecipe.Property().setBlockInputOffset(new Vec3i(0, -1, 0)).setConsumeInputBlocks(true).setInputBlocks(input).setBlockOutputOffset(new Vec3i(0, -1, 0)).setResultBlocks(result));
    }

    @Override
    public RecipeType<BlockCrushRecipe> getType() {
        return (RecipeType)ModRecipeTypes.BLOCK_CRUSH_TYPE.get();
    }

    @Override
    public RecipeSerializer<BlockCrushRecipe> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.BLOCK_CRUSH_SERIALIZER.get();
    }

    public static Builder builder(HolderGetter<Block> getter) {
        return new Builder(getter);
    }

    public static class Builder
    extends AbstractRecipeBuilder<BlockCrushRecipe> {
        private final HolderGetter<Block> getter;
        private BlockStatePredicate input = null;
        private ChanceBlockState result = null;

        public Builder(HolderGetter<Block> getter) {
            this.getter = getter;
        }

        public Builder input(BlockStatePredicate input) {
            this.input = input;
            return this;
        }

        public Builder input(TagKey<Block> input) {
            this.input = BlockStatePredicate.builder(this.getter).of(input).build();
            return this;
        }

        public Builder input(Block input) {
            this.input = BlockStatePredicate.builder(this.getter).of(new Block[]{input}).build();
            return this;
        }

        public Builder result(ChanceBlockState result) {
            this.result = result;
            return this;
        }

        public Builder result(Block result) {
            this.result = new ChanceBlockState(result.defaultBlockState(), 1.0f);
            return this;
        }

        @Override
        public BlockCrushRecipe buildRecipe() {
            return new BlockCrushRecipe(this.input, this.result);
        }

        @Override
        public void validate(ResourceLocation pId) {
            if (this.input == null) {
                throw new IllegalArgumentException("Recipe input must not be null, RecipeId: " + String.valueOf(pId));
            }
            if (this.result == null) {
                throw new IllegalArgumentException("Recipe result must not be null, RecipeId: " + String.valueOf(pId));
            }
        }

        @Override
        public String getType() {
            return "block_crush";
        }

        @Override
        public Item getResult() {
            return WrapUtils.getItem(this.result);
        }
    }

    public static class Serializer
    implements RecipeSerializer<BlockCrushRecipe> {
        private static final MapCodec<BlockCrushRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockStatePredicate.CODEC.fieldOf("input").forGetter(AbstractProcessRecipe::getFirstInputBlock), (App)ChanceBlockState.CODEC.codec().fieldOf("result").forGetter(AbstractProcessRecipe::getFirstResultBlock)).apply((Applicative)instance, BlockCrushRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, BlockCrushRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockStatePredicate.STREAM_CODEC, AbstractProcessRecipe::getFirstInputBlock, (StreamCodec)ChanceBlockState.STREAM_CODEC, AbstractProcessRecipe::getFirstResultBlock, BlockCrushRecipe::new);

        public MapCodec<BlockCrushRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BlockCrushRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

