/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.recipe.anvil.wrap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.anvilcraft.lib.recipe.component.BlockStatePredicate;
import dev.anvilcraft.lib.recipe.component.ChanceBlockState;
import dev.anvilcraft.lib.recipe.component.ChanceItemStack;
import dev.anvilcraft.lib.recipe.component.ItemIngredientPredicate;
import dev.anvilcraft.lite.init.reicpe.ModRecipeTypes;
import dev.anvilcraft.lite.recipe.anvil.util.WrapUtils;
import dev.anvilcraft.lite.recipe.anvil.wrap.AbstractProcessRecipe;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class ItemInjectRecipe
extends AbstractProcessRecipe<ItemInjectRecipe> {
    public ItemInjectRecipe(List<ItemIngredientPredicate> itemIngredients, List<ChanceItemStack> results, BlockStatePredicate blockIngredient, ChanceBlockState blockResult) {
        super(new AbstractProcessRecipe.Property().setItemInputOffset(Vec3.ZERO).setInputItems(itemIngredients).setItemOutputOffset(new Vec3(0.0, -1.0, 0.0)).setResultItems(results).setBlockInputOffset(new Vec3i(0, -1, 0)).setInputBlocks(blockIngredient).setBlockOutputOffset(new Vec3i(0, -1, 0)).setResultBlocks(blockResult));
    }

    @Override
    public RecipeSerializer<ItemInjectRecipe> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.ITEM_INJECT_SERIALIZER.get();
    }

    @Override
    public RecipeType<ItemInjectRecipe> getType() {
        return (RecipeType)ModRecipeTypes.ITEM_INJECT_TYPE.get();
    }

    public static Builder builder(HolderGetter<Item> getter, HolderGetter<Block> blockGetter) {
        return new Builder(getter, blockGetter);
    }

    public static class Builder
    extends AbstractProcessRecipe.SimpleAbstractBuilder<ItemInjectRecipe, Builder> {
        BlockStatePredicate.Builder blockIngredient;
        ChanceBlockState blockResult = null;

        protected Builder(HolderGetter<Item> getter, HolderGetter<Block> blockGetter) {
            super(getter);
            this.blockIngredient = BlockStatePredicate.builder(blockGetter);
        }

        public Builder inputBlock(Block block) {
            this.blockIngredient.of(new Block[]{block});
            return this;
        }

        public Builder inputBlock(Supplier<? extends Block> block) {
            return this.inputBlock(block.get());
        }

        public Builder resultBlock(Block block) {
            this.blockResult = new ChanceBlockState(block.defaultBlockState(), 1.0f);
            return this;
        }

        public Builder resultBlock(Supplier<? extends Block> block) {
            return this.resultBlock(block.get());
        }

        @Override
        public String getType() {
            return "item_inject";
        }

        @Override
        public void validate(ResourceLocation pId) {
            if (this.itemIngredients.isEmpty()) {
                throw new IllegalArgumentException("Recipe ingredients must not be empty, RecipeId: " + String.valueOf(pId));
            }
        }

        @Override
        protected ItemInjectRecipe of(List<ItemIngredientPredicate> itemIngredients, List<ChanceItemStack> results) {
            return new ItemInjectRecipe(itemIngredients, results, this.blockIngredient.build(), this.blockResult);
        }

        @Override
        public Item getResult() {
            return WrapUtils.getItem(this.blockResult);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }

    public static class Serializer
    implements RecipeSerializer<ItemInjectRecipe> {
        private static final MapCodec<ItemInjectRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemIngredientPredicate.CODEC.codec().listOf().optionalFieldOf("ingredients", List.of()).forGetter(AbstractProcessRecipe::getInputItems), (App)ChanceItemStack.CODEC.listOf().optionalFieldOf("results", List.of()).forGetter(AbstractProcessRecipe::getResultItems), (App)BlockStatePredicate.CODEC.fieldOf("block_ingredient").forGetter(AbstractProcessRecipe::getFirstInputBlock), (App)ChanceBlockState.CODEC.codec().fieldOf("block_result").forGetter(AbstractProcessRecipe::getFirstResultBlock)).apply((Applicative)instance, ItemInjectRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, ItemInjectRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemIngredientPredicate.STREAM_CODEC.apply(ByteBufCodecs.list()), AbstractProcessRecipe::getInputItems, (StreamCodec)ChanceItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), AbstractProcessRecipe::getResultItems, (StreamCodec)BlockStatePredicate.STREAM_CODEC, AbstractProcessRecipe::getFirstInputBlock, (StreamCodec)ChanceBlockState.STREAM_CODEC, AbstractProcessRecipe::getFirstResultBlock, ItemInjectRecipe::new);

        public MapCodec<ItemInjectRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ItemInjectRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

