/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.client.model.entity;

import dev.anvilcraft.lite.client.renderer.entity.state.MagnetizedNodeRenderState;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;

public class MagnetizedNodeModel
extends EntityModel<MagnetizedNodeRenderState> {
    private final KeyframeAnimation idleAnimation;
    public static final AnimationDefinition ROTATING = AnimationDefinition.Builder.withLength((float)6.0f).looping().addAnimation("rotating", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(2.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)360.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(4.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)720.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(6.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)1080.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("main", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(3.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)-360.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(6.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)-720.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).build();

    public MagnetizedNodeModel(ModelPart root) {
        super(root, RenderType::entityTranslucent);
        this.idleAnimation = ROTATING.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition rotating = partdefinition.addOrReplaceChild("rotating", CubeListBuilder.create().texOffs(0, 4).addBox(-3.0f, -3.0f, -1.0f, 1.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        rotating.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 4).addBox(-3.0f, -3.0f, -1.0f, 1.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)2.0944f, (float)0.0f));
        rotating.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 4).addBox(-3.0f, -3.0f, -1.0f, 1.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.0944f, (float)0.0f));
        partdefinition.addOrReplaceChild("main", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public void setupAnim(MagnetizedNodeRenderState renderState) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.idleAnimation.apply(renderState.idle, renderState.ageInTicks);
    }
}

