/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.data.recipe;

import dev.anvilcraft.lite.data.recipe.BlockCompressRecipeLoader;
import dev.anvilcraft.lite.data.recipe.BlockCrushRecipeLoader;
import dev.anvilcraft.lite.data.recipe.BlockSmearRecipeLoader;
import dev.anvilcraft.lite.data.recipe.BulgingRecipeLoader;
import dev.anvilcraft.lite.data.recipe.CookingRecipeLoader;
import dev.anvilcraft.lite.data.recipe.ItemCompressRecipeLoader;
import dev.anvilcraft.lite.data.recipe.ItemCrushRecipeLoader;
import dev.anvilcraft.lite.data.recipe.ItemInjectRecipeLoader;
import dev.anvilcraft.lite.data.recipe.MeshRecipeLoader;
import dev.anvilcraft.lite.data.recipe.ModRecipeLoader;
import dev.anvilcraft.lite.data.recipe.SqueezingRecipeLoader;
import dev.anvilcraft.lite.data.recipe.StampingRecipeLoader;
import dev.anvilcraft.lite.data.recipe.SuperHeatingRecipeLoader;
import dev.anvilcraft.lite.data.recipe.UnpackRecipeLoader;
import dev.anvilcraft.lite.data.recipe.VanillaRecipeLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;

public class ModRecipeProvider
extends RecipeProvider {
    public final List<ModRecipeLoader> providers = new ArrayList<ModRecipeLoader>();

    protected ModRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
        super(registries, output);
    }

    protected void buildRecipes() {
        this.addProvider(BlockCrushRecipeLoader::new);
        this.addProvider(ItemCrushRecipeLoader::new);
        this.addProvider(UnpackRecipeLoader::new);
        this.addProvider(BlockCompressRecipeLoader::new);
        this.addProvider(ItemCompressRecipeLoader::new);
        this.addProvider(MeshRecipeLoader::new);
        this.addProvider(CookingRecipeLoader::new);
        this.addProvider(BulgingRecipeLoader::new);
        this.addProvider(StampingRecipeLoader::new);
        this.addProvider(BlockSmearRecipeLoader::new);
        this.addProvider(ItemInjectRecipeLoader::new);
        this.addProvider(SqueezingRecipeLoader::new);
        this.addProvider(SuperHeatingRecipeLoader::new);
        this.addProvider(VanillaRecipeLoader::new);
        this.providers.forEach(ModRecipeLoader::buildRecipes);
    }

    public <T extends ModRecipeLoader> void addProvider(BiFunction<HolderLookup.Provider, RecipeOutput, T> provider) {
        this.providers.add((ModRecipeLoader)((Object)provider.apply(this.registries, this.output)));
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> future) {
            super(output, future);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
            return new ModRecipeProvider(provider, output);
        }

        public String getName() {
            return "AnvilCraft Lite Recipes";
        }
    }
}

