/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.dispense;

import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public interface ModDispenseItemBehavior
extends DispenseItemBehavior {
    public static final DefaultDispenseItemBehavior DEFAULT_DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior();

    private static void playDefaultSound(BlockSource blockSource) {
        blockSource.level().levelEvent(1000, blockSource.pos(), 0);
    }

    private static void playDefaultAnimation(BlockSource blockSource, Direction direction) {
        blockSource.level().levelEvent(2000, blockSource.pos(), direction.get3DDataValue());
    }

    default public ItemStack dispense(BlockSource blockSource, ItemStack item) {
        this.playSound(blockSource);
        this.playAnimation(blockSource, (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
        ItemStack stack = this.execute(blockSource, item.copy());
        if (!ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)stack) || stack.getCount() != item.getCount()) {
            return stack;
        }
        return DEFAULT_DISPENSE_ITEM_BEHAVIOR.dispense(blockSource, item);
    }

    public ItemStack execute(BlockSource var1, ItemStack var2);

    default public void playSound(BlockSource blockSource) {
        ModDispenseItemBehavior.playDefaultSound(blockSource);
    }

    default public void playAnimation(BlockSource blockSource, Direction direction) {
        ModDispenseItemBehavior.playDefaultAnimation(blockSource, direction);
    }
}

