/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.integration.jei.category.anvil;

import dev.anvilcraft.lite.init.reicpe.ModRecipeTypes;
import dev.anvilcraft.lite.integration.jei.AnvilCraftJeiPlugin;
import dev.anvilcraft.lite.integration.jei.util.BlockTagUtil;
import dev.anvilcraft.lite.integration.jei.util.JeiRecipeUtil;
import dev.anvilcraft.lite.integration.jei.util.JeiRenderHelper;
import dev.anvilcraft.lite.recipe.anvil.wrap.BlockSmearRecipe;
import dev.anvilcraft.lite.util.render.RenderHelper;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockSmearCategory
implements IRecipeCategory<RecipeHolder<BlockSmearRecipe>> {
    public static final int WIDTH = 162;
    public static final int HEIGHT = 64;
    private final IDrawable arrowDefault;
    private final IDrawable icon;
    private final Component title;
    private final ITickTimer timer;

    public BlockSmearCategory(IGuiHelper helper) {
        this.arrowDefault = JeiRenderHelper.getArrowDefault(helper);
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)Items.ANVIL));
        this.title = Component.translatable((String)"gui.anvilcraft.category.block_smear");
        this.timer = helper.createTickTimer(30, 60, true);
    }

    public IRecipeType<RecipeHolder<BlockSmearRecipe>> getRecipeType() {
        return AnvilCraftJeiPlugin.BLOCK_SMEAR;
    }

    public Component getTitle() {
        return this.title;
    }

    public int getWidth() {
        return 162;
    }

    public int getHeight() {
        return 64;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<BlockSmearRecipe> recipeHolder, IFocusGroup focuses) {
        BlockSmearRecipe recipe = (BlockSmearRecipe)recipeHolder.value();
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(recipe.getInputBlocks().stream().flatMap(blockStatePredicate -> blockStatePredicate.getBlocks().stream().map(blockHolder -> new ItemStack((ItemLike)blockHolder.value()))).toList());
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).add(new ItemStack((ItemLike)recipe.getFirstResultBlock().state().getBlock()));
    }

    public void draw(RecipeHolder<BlockSmearRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Rect2i area = AnvilCraftJeiPlugin.AREA_WHEN_DRAW.get();
        int left = area.getX() - 9;
        int top = area.getY();
        BlockSmearRecipe recipe = (BlockSmearRecipe)recipeHolder.value();
        float anvilYOffset = JeiRenderHelper.getAnvilAnimationOffset(this.timer);
        this.arrowDefault.draw(guiGraphics, 73, 35);
        for (int i = recipe.getInputBlocks().size() - 1; i >= 0; --i) {
            BlockState renderedState;
            List input = recipe.getInputBlocks().get(i).constructStatesForRender();
            if (input.isEmpty() || (renderedState = (BlockState)input.get((int)(System.currentTimeMillis() / 1000L % (long)input.size()))) == null) continue;
            RenderHelper.renderSingleBlock(guiGraphics, renderedState, left + 50, top + 30 + 10 * i, 12.0f);
        }
        RenderHelper.renderSingleBlock(guiGraphics, Blocks.ANVIL.defaultBlockState(), left + 50, (float)(top + 12) + anvilYOffset, 12.0f);
        recipe.getFirstInputBlock();
        List input = recipe.getFirstInputBlock().constructStatesForRender();
        BlockState renderedState = (BlockState)input.get((int)(System.currentTimeMillis() / 1000L % (long)input.size()));
        RenderHelper.renderMultipleBlocks(guiGraphics, List.of(Blocks.ANVIL.defaultBlockState(), renderedState, recipe.getFirstResultBlock().state()), left + 110, top + 20, 12.0f);
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<BlockSmearRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        super.getTooltip(tooltip, recipeHolder, recipeSlotsView, mouseX, mouseY);
        BlockSmearRecipe recipe = (BlockSmearRecipe)recipeHolder.value();
        if (mouseX >= 40.0 && mouseX <= 58.0) {
            if (mouseY >= 24.0 && mouseY < 42.0) {
                tooltip.addAll(BlockTagUtil.getTooltipsForInput(recipe.getInputBlocks().getFirst()));
            }
            if (mouseY >= 42.0 && mouseY <= 52.0) {
                tooltip.addAll(BlockTagUtil.getTooltipsForInput(recipe.getInputBlocks().getLast()));
            }
        }
        if (mouseX >= 100.0 && mouseX <= 118.0) {
            if (mouseY >= 24.0 && mouseY < 42.0) {
                tooltip.addAll(BlockTagUtil.getTooltipsForInput(recipe.getInputBlocks().getFirst()));
            }
            if (mouseY >= 42.0 && mouseY <= 52.0) {
                tooltip.add((FormattedText)recipe.getFirstResultBlock().state().getBlock().getName());
            }
        }
    }

    public static void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(AnvilCraftJeiPlugin.BLOCK_SMEAR, JeiRecipeUtil.getRecipeHoldersFromType((RecipeType)ModRecipeTypes.BLOCK_SMEAR_TYPE.get()));
    }

    public static void registerCraftingStations(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(AnvilCraftJeiPlugin.BLOCK_SMEAR, new ItemStack[]{new ItemStack((ItemLike)Items.ANVIL)});
    }
}

