/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.integration.jei.category.anvil;

import dev.anvilcraft.lite.init.reicpe.ModRecipeTypes;
import dev.anvilcraft.lite.integration.jei.AnvilCraftJeiPlugin;
import dev.anvilcraft.lite.integration.jei.category.anvil.AbstractProgressCategory;
import dev.anvilcraft.lite.integration.jei.drawable.DrawableBlockStateIcon;
import dev.anvilcraft.lite.integration.jei.util.JeiRecipeUtil;
import dev.anvilcraft.lite.integration.jei.util.JeiRenderHelper;
import dev.anvilcraft.lite.integration.jei.util.JeiSlotUtil;
import dev.anvilcraft.lite.recipe.anvil.wrap.SuperHeatingRecipe;
import dev.anvilcraft.lite.util.render.RenderHelper;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SuperHeatingCategory
extends AbstractProgressCategory<SuperHeatingRecipe> {
    public SuperHeatingCategory(IGuiHelper helper) {
        super(helper, new DrawableBlockStateIcon(Blocks.CAULDRON.defaultBlockState(), Blocks.LAVA_CAULDRON.defaultBlockState()), (Component)Component.translatable((String)"gui.anvilcraft.category.super_heating"));
    }

    public IRecipeType<RecipeHolder<SuperHeatingRecipe>> getRecipeType() {
        return AnvilCraftJeiPlugin.SUPER_HEATING;
    }

    public void draw(RecipeHolder<SuperHeatingRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Rect2i area = AnvilCraftJeiPlugin.AREA_WHEN_DRAW.get();
        int left = area.getX() - 9;
        int top = area.getY();
        SuperHeatingRecipe recipe = (SuperHeatingRecipe)recipeHolder.value();
        float anvilYOffset = JeiRenderHelper.getAnvilAnimationOffset(this.timer);
        RenderHelper.renderMultipleBlocks(guiGraphics, List.of(Blocks.CAULDRON.defaultBlockState(), Blocks.LAVA_CAULDRON.defaultBlockState()), left + 81, top + 30, 12.0f);
        RenderHelper.renderSingleBlock(guiGraphics, Blocks.ANVIL.defaultBlockState(), left + 81, (float)(top + 12) + anvilYOffset, 12.0f);
        this.arrowIn.draw(guiGraphics, 54, 30);
        this.arrowOut.draw(guiGraphics, 92, 29);
        JeiSlotUtil.drawInputSlots(guiGraphics, this.slotDefault, recipe.getInputItems().size());
        if (JeiRecipeUtil.isChance(recipe.getResultItems())) {
            JeiSlotUtil.drawOutputSlots(guiGraphics, this.slotProbability, recipe.getResultItems().size());
        } else {
            JeiSlotUtil.drawOutputSlots(guiGraphics, this.slotDefault, recipe.getResultItems().size());
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<SuperHeatingRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        SuperHeatingRecipe recipe = (SuperHeatingRecipe)recipeHolder.value();
        if (mouseX >= 72.0 && mouseX <= 90.0) {
            if (mouseY >= 24.0 && mouseY <= 43.0) {
                tooltip.add((FormattedText)recipe.getHasCauldron().getFluidCauldron().getName());
            }
            if (mouseY >= 34.0 && mouseY <= 53.0) {
                tooltip.add((FormattedText)Blocks.LAVA_CAULDRON.getName());
            }
        }
        if (mouseX >= 124.0 && mouseX <= 140.0 && mouseY >= 24.0 && mouseY <= 42.0 && recipe.getResultItems().isEmpty()) {
            MutableComponent text = recipe.getHasCauldron().getTransformCauldron().getName();
            tooltip.add((FormattedText)text);
        }
    }

    public static void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(AnvilCraftJeiPlugin.SUPER_HEATING, JeiRecipeUtil.getRecipeHoldersFromType((RecipeType)ModRecipeTypes.SUPER_HEATING_TYPE.get()));
    }

    public static void registerCraftingStations(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(AnvilCraftJeiPlugin.SUPER_HEATING, new ItemStack[]{new ItemStack((ItemLike)Items.ANVIL)});
        registration.addCraftingStation(AnvilCraftJeiPlugin.SUPER_HEATING, new ItemStack[]{new ItemStack((ItemLike)Items.CAULDRON)});
    }
}

