/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.item;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.anvilcraft.lite.AnvilCraftLite;
import dev.anvilcraft.lite.init.item.ModItems;
import dev.anvilcraft.lite.item.better.BetterItem;
import dev.anvilcraft.lite.util.Util;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.TooltipDisplay;

public class CrabClawItem
extends BetterItem {
    public static final AttributeModifier RANGE_ATTRIBUTE_MODIFIER = new AttributeModifier(AnvilCraftLite.of("range_modifier"), 3.0, AttributeModifier.Operation.ADD_VALUE);
    private static final Supplier<Multimap<Holder<Attribute>, AttributeModifier>> RANGE_MODIFIER_SUPPLIER = Suppliers.memoize(() -> ImmutableMultimap.of((Object)Attributes.BLOCK_INTERACTION_RANGE, (Object)RANGE_ATTRIBUTE_MODIFIER, (Object)Attributes.ENTITY_INTERACTION_RANGE, (Object)RANGE_ATTRIBUTE_MODIFIER));
    public static final String CRAB_CLAW_MARKER = "crabClaw";
    public static final String DUAL_CRAB_CLAW_MARKER = "dualCrabClaw";

    public CrabClawItem(Item.Properties properties) {
        super(properties);
    }

    public static void holdingCrabClawIncreasesRange(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (entity.level().isClientSide) {
            return;
        }
        CompoundTag customData = entity.getPersistentData();
        boolean inOffHand = player.getOffhandItem().is(ModItems.CRAB_CLAW);
        boolean inMainHand = player.getMainHandItem().is(ModItems.CRAB_CLAW);
        boolean holdingDualCrabClaw = inOffHand && inMainHand;
        boolean holdingCrabClaw = inOffHand || inMainHand;
        boolean wasHoldingCrabClaw = customData.contains(CRAB_CLAW_MARKER);
        boolean wasHoldingDualCrabClaw = customData.contains(DUAL_CRAB_CLAW_MARKER);
        if (!holdingCrabClaw) {
            player.getAttributes().removeAttributeModifiers(RANGE_MODIFIER_SUPPLIER.get());
            if (wasHoldingCrabClaw) {
                customData.remove(CRAB_CLAW_MARKER);
            }
        } else {
            player.getAttributes().addTransientAttributeModifiers(RANGE_MODIFIER_SUPPLIER.get());
            if (!wasHoldingDualCrabClaw) {
                customData.putBoolean(CRAB_CLAW_MARKER, true);
            }
        }
        if (!holdingDualCrabClaw) {
            if (wasHoldingDualCrabClaw) {
                customData.remove(DUAL_CRAB_CLAW_MARKER);
            }
        } else if (!wasHoldingDualCrabClaw) {
            customData.putBoolean(DUAL_CRAB_CLAW_MARKER, true);
        }
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        Shulker shulker;
        if (!(target instanceof Shulker) || !(shulker = (Shulker)target).isAlive()) {
            return InteractionResult.PASS;
        }
        if (!player.level().isClientSide) {
            Optional.ofNullable(shulker.getAttribute(Attributes.ARMOR)).ifPresent(attribute -> attribute.removeModifier(Shulker.COVERED_ARMOR_MODIFIER_ID));
            shulker.getEntityData().set(Shulker.DATA_PEEK_ID, (Object)100);
        }
        return Util.sidedSuccess(player.level().isClientSide);
    }

    @Override
    public void appendTooltip(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> adder, TooltipFlag flag) {
        adder.accept(CommonComponents.EMPTY);
        adder.accept((Component)Component.translatable((String)"item.modifiers.hand").withStyle(ChatFormatting.GRAY));
        adder.accept((Component)Component.translatable((String)("attribute.modifier.plus." + RANGE_ATTRIBUTE_MODIFIER.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(RANGE_ATTRIBUTE_MODIFIER.amount()), Component.translatable((String)((Attribute)Attributes.BLOCK_INTERACTION_RANGE.value()).getDescriptionId())}).withStyle(((Attribute)Attributes.BLOCK_INTERACTION_RANGE.value()).getStyle(true)));
        adder.accept((Component)Component.translatable((String)("attribute.modifier.plus." + RANGE_ATTRIBUTE_MODIFIER.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(RANGE_ATTRIBUTE_MODIFIER.amount()), Component.translatable((String)((Attribute)Attributes.ENTITY_INTERACTION_RANGE.value()).getDescriptionId())}).withStyle(((Attribute)Attributes.ENTITY_INTERACTION_RANGE.value()).getStyle(true)));
    }
}

